/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public abstract class AbstractClusterTest {
    @Rule
    public TestName testName = new TestName();
    protected LifeSupport life;
    private final ClusterManager.Provider provider;
    protected ClusterManager clusterManager;
    protected ClusterManager.ManagedCluster cluster;

    protected AbstractClusterTest(ClusterManager.Provider provider) {
        this.provider = provider;
    }

    protected AbstractClusterTest() {
        this(ClusterManager.clusterOfSize(3));
    }

    @Before
    public void before() throws Exception {
        this.life = new LifeSupport();
        File dir = TargetDirectory.forTest(this.getClass()).cleanDirectory(this.testName.getMethodName());
        this.clusterManager = (ClusterManager)((Object)this.life.add((Object)new ClusterManager(this.provider, dir, MapUtil.stringMap((String[])new String[]{ClusterSettings.default_timeout.name(), "1s"})){

            @Override
            protected void config(GraphDatabaseBuilder builder, String clusterName, InstanceId serverId) {
                super.config(builder, clusterName, serverId);
                AbstractClusterTest.this.configureClusterMember(builder, clusterName, serverId);
            }

            @Override
            protected void insertInitialData(GraphDatabaseService db, String name, InstanceId serverId) {
                super.insertInitialData(db, name, serverId);
                AbstractClusterTest.this.insertClusterMemberInitialData(db, name, serverId);
            }
        }));
        this.life.start();
        this.cluster = this.clusterManager.getDefaultCluster();
        this.cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
    }

    protected void configureClusterMember(GraphDatabaseBuilder builder, String clusterName, InstanceId serverId) {
    }

    protected void insertClusterMemberInitialData(GraphDatabaseService db, String name, InstanceId serverId) {
    }

    @After
    public void after() throws Exception {
        Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.named((String)(this.getClass() + "-Shutdown-Thread"))).submit(new Runnable(){

            @Override
            public void run() {
                AbstractClusterTest.this.life.shutdown();
            }
        }).get();
    }
}

