/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.ha;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.util.DumpLogicalLog;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public class ClusterRule
extends ExternalResource {
    private final Class<?> testClass;
    private ClusterManager clusterManager;
    private File storeDirectory;
    private Description description;

    public static void main(String[] args) throws IOException {
        DumpLogicalLog.main((String[])new String[]{"/Users/chris/workspaces/neo4j/neo4j-2.2/enterprise/ha/target/test-data/org.neo4j.kernel.api.SchemaIndexHaIT/e9d355b22fea23deb9f278434cb5abaf/neo4j.ha/server3"});
    }

    public ClusterRule(Class<?> testClass) {
        this.testClass = testClass;
    }

    public ClusterManager.ManagedCluster startCluster() throws Exception {
        return this.startCluster(new HighlyAvailableGraphDatabaseFactory(), MapUtil.stringMap((String[])new String[0]));
    }

    public ClusterManager.ManagedCluster startCluster(Map<String, String> config) throws Exception {
        return this.startCluster(new HighlyAvailableGraphDatabaseFactory(), config);
    }

    public ClusterManager.ManagedCluster startCluster(HighlyAvailableGraphDatabaseFactory databaseFactory) throws Exception {
        return this.startCluster(databaseFactory, MapUtil.stringMap((String[])new String[0]));
    }

    public ClusterManager.ManagedCluster startCluster(HighlyAvailableGraphDatabaseFactory databaseFactory, Map<String, String> config) throws Exception {
        config.putAll(MapUtil.stringMap((String[])new String[]{ClusterSettings.default_timeout.name(), "1s", HaSettings.tx_push_factor.name(), "0"}));
        this.clusterManager = new ClusterManager.Builder(this.storeDirectory).withDbFactory(databaseFactory).build();
        try {
            this.clusterManager.start();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        ClusterManager.ManagedCluster cluster = this.clusterManager.getDefaultCluster();
        cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        return cluster;
    }

    public Statement apply(Statement base, Description description) {
        this.description = description;
        return super.apply(base, description);
    }

    protected void before() throws Throwable {
        this.storeDirectory = TargetDirectory.forTest(this.testClass).directoryForDescription(this.description);
    }

    protected void after() {
        try {
            if (this.clusterManager != null) {
                this.clusterManager.stop();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

