/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.SlaveLocksClient;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class SlaveLockManager
extends LifecycleAdapter
implements Locks {
    private final RequestContextFactory requestContextFactory;
    private final Locks local;
    private final Master master;
    private final AvailabilityGuard availabilityGuard;
    private final Configuration config;

    public SlaveLockManager(Locks localLocks, RequestContextFactory requestContextFactory, Master master, AvailabilityGuard availabilityGuard, Configuration config) {
        this.requestContextFactory = requestContextFactory;
        this.availabilityGuard = availabilityGuard;
        this.config = config;
        this.local = localLocks;
        this.master = master;
    }

    public Locks.Client newClient() {
        return new SlaveLocksClient(this.master, this.local.newClient(), this.local, this.requestContextFactory, this.availabilityGuard, this.config);
    }

    public void accept(Locks.Visitor visitor) {
        this.local.accept(visitor);
    }

    public static interface Configuration {
        public long getAvailabilityTimeout();
    }
}

