/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.impl.util.LazySingleReference;

public class DelegateInvocationHandler<T>
implements InvocationHandler {
    private volatile T delegate;
    private final LazySingleReference<T> concrete;

    public DelegateInvocationHandler(final Class<T> interfaceClass) {
        this.concrete = new LazySingleReference<T>(){

            protected T create() {
                return Proxy.newProxyInstance(DelegateInvocationHandler.class.getClassLoader(), new Class[]{interfaceClass}, new Concrete());
            }
        };
    }

    public void setDelegate(T delegate) {
        this.delegate = delegate;
        this.harden();
        this.concrete.invalidate();
    }

    public void harden() {
        ((Concrete)Proxy.getInvocationHandler(this.concrete.instance())).set(this.delegate);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.delegate == null) {
            throw new TransactionFailureException("Instance state changed after this transaction started.");
        }
        return DelegateInvocationHandler.proxyInvoke(this.delegate, method, args);
    }

    private static Object proxyInvoke(Object delegate, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(delegate, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public T cement() {
        return (T)this.concrete.instance();
    }

    public static <T> T snapshot(T proxiedInstance) {
        DelegateInvocationHandler delegateHandler = (DelegateInvocationHandler)Proxy.getInvocationHandler(proxiedInstance);
        return delegateHandler.delegate;
    }

    public String toString() {
        return "Delegate[" + this.delegate + "]";
    }

    private static class Concrete<T>
    implements InvocationHandler {
        private volatile T delegate;

        private Concrete() {
        }

        void set(T delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.delegate == null) {
                throw new IllegalStateException("Transaction state is not valid. Perhaps a state change of the database has happened while this transaction was running?");
            }
            return DelegateInvocationHandler.proxyInvoke(this.delegate, method, args);
        }

        public String toString() {
            return "Concrete[" + this.delegate + "]";
        }
    }
}

