/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

public class HPCMemoryConfig {
    private final long nodeCacheSize;
    private final long relCacheSize;
    private final float nodeLookupTableFraction;
    private final float relLookupTableFraction;
    private final Source source;

    public HPCMemoryConfig(long nodeCacheSize, long relCacheSize, float nodeLookupTableFraction, float relLookupTableFraction, Source source) {
        this.nodeCacheSize = nodeCacheSize;
        this.relCacheSize = relCacheSize;
        this.nodeLookupTableFraction = nodeLookupTableFraction;
        this.relLookupTableFraction = relLookupTableFraction;
        this.source = source;
    }

    public Source source() {
        return this.source;
    }

    public long nodeCacheSize() {
        return this.nodeCacheSize;
    }

    public long relCacheSize() {
        return this.relCacheSize;
    }

    public float nodeLookupTableFraction() {
        return this.nodeLookupTableFraction;
    }

    public float relLookupTableFraction() {
        return this.relLookupTableFraction;
    }

    public long total() {
        return (long)((float)(this.nodeCacheSize + this.relCacheSize) + (this.relLookupTableFraction + this.nodeLookupTableFraction) / 100.0f * (float)Runtime.getRuntime().maxMemory());
    }

    public static enum Source {
        DEFAULT_MEMORY_RATIO,
        EXPLICIT_MEMORY_RATIO,
        SPECIFIC,
        SPECIFIC_OVERRIDING_RATIO;

    }
}

