/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.Description;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Function2;
import org.neo4j.helpers.Settings;
import org.neo4j.kernel.configuration.Internal;
import org.neo4j.kernel.impl.cache.HPCMemoryConfig;
import org.neo4j.kernel.impl.cache.HPCSettingFunctions;

@Description(value="High Performance Cache configuration settings")
public class HighPerformanceCacheSettings {
    @Description(value="Maximum size of the heap memory to dedicate to the cached nodes. Right before the maximum size is reached a purge is performed. The purge will evict objects from the cache until the cache size gets below 90% of the maximum size. Optimal settings for the maximum size depends on the size of your graph. The configured maximum size should leave enough room for other objects to coexist in the same JVM. At the same time it should be large enough to keep loading from the low level cache at a minimum. Predicted load on the JVM as well as layout of domain level objects should also be taken into consideration.")
    public static final Setting<Long> node_cache_size = Settings.setting((String)"node_cache_size", (Function)Settings.BYTES, (String)Settings.NO_DEFAULT);
    @Description(value="Maximum size of the heap memory to dedicate to the cached relationships. See node_cache_size for more information.")
    public static final Setting<Long> relationship_cache_size = Settings.setting((String)"relationship_cache_size", (Function)Settings.BYTES, (String)Settings.NO_DEFAULT);
    @Description(value="Fraction of the heap to dedicate to the array holding the nodes in the cache. Specifying `5` will let that array itself take up 5% out of the entire heap. Increasing this figure will reduce the chance of hash collisions at the expense of more heap used for it. More collisions means more redundant loading of objects from the low level cache.")
    public static final Setting<Float> node_cache_array_fraction = Settings.setting((String)"node_cache_array_fraction", (Function)Settings.FLOAT, (String)"1.0", (Function2[])new Function2[]{Settings.range((Comparable)Float.valueOf(1.0f), (Comparable)Float.valueOf(10.0f))});
    @Description(value="Fraction of the heap to dedicate to the array holding the relationships in the cache. See node_cache_array_fraction for more information.")
    public static final Setting<Float> relationship_cache_array_fraction = Settings.setting((String)"relationship_cache_array_fraction", (Function)Settings.FLOAT, (String)"1.0", (Function2[])new Function2[]{Settings.range((Comparable)Float.valueOf(1.0f), (Comparable)Float.valueOf(10.0f))});
    @Description(value="Set how much of the memory available for caching to use for caching. It is recommended to not have this value exceed 70 percent.")
    public static final Setting<HPCMemoryConfig> cache_memory = Settings.setting((String)"cache.memory_ratio", HPCSettingFunctions.CACHE_MEMORY_RATIO, (String)HPCSettingFunctions.DEFAULT, (Function2[])new Function2[]{HPCSettingFunctions.OTHER_CACHE_SETTINGS_OVERRIDE, HPCSettingFunctions.TOTAL_NOT_ALLOWED_ABOVE_HEAP});
    @Internal
    public static final Setting<Long> log_interval = Settings.setting((String)"high_performance_cache_min_log_interval", (Function)Settings.DURATION, (String)"60s");
}

