/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatListener;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public class TestSlaveOnlyCluster {
    private final TargetDirectory directory = TargetDirectory.forTest(this.getClass());
    private static final String PROPERTY = "foo";
    private static final String VALUE = "bar";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterElectionAfterMasterRecoversInSlaveOnlyCluster() throws Throwable {
        ClusterManager clusterManager = this.createCluster("masterrecovery", 1, 2);
        try {
            clusterManager.start();
            ClusterManager.ManagedCluster cluster = clusterManager.getDefaultCluster();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            CountDownLatch masterFailedLatch = this.createMasterFailLatch(cluster);
            ClusterManager.RepairKit repairKit = cluster.fail(master);
            masterFailedLatch.await(60L, TimeUnit.SECONDS);
            repairKit.repair();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            clusterManager.getDefaultCluster().await(ClusterManager.allSeesAllAsAvailable());
            long nodeId = this.createNodeWithPropertyOn(cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]), PROPERTY, VALUE);
            try (Transaction ignore = master.beginTx();){
                Assert.assertThat((Object)((String)master.getNodeById(nodeId).getProperty(PROPERTY)), (Matcher)CoreMatchers.equalTo((Object)VALUE));
            }
        }
        finally {
            clusterManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterElectionAfterSlaveOnlyInstancesStartFirst() throws Throwable {
        ClusterManager clusterManager = this.createCluster("slaveonly", 1, 2);
        try {
            clusterManager.start();
            ClusterManager.ManagedCluster cluster = clusterManager.getDefaultCluster();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            Assert.assertThat((Object)cluster.getServerId(cluster.getMaster()), (Matcher)CoreMatchers.equalTo((Object)new InstanceId(3)));
        }
        finally {
            clusterManager.stop();
        }
    }

    private ClusterManager createCluster(String dirname, int ... slaveIds) throws URISyntaxException {
        File dir = this.directory.cleanDirectory(dirname);
        System.out.println(dir);
        ClusterManager.Provider provider = ClusterManager.fromXml(this.getClass().getResource("/threeinstances.xml").toURI());
        HashMap<Integer, Map<String, String>> instanceConfig = new HashMap<Integer, Map<String, String>>(slaveIds.length);
        for (int slaveId : slaveIds) {
            instanceConfig.put(slaveId, MapUtil.stringMap((String[])new String[]{HaSettings.slave_only.name(), "true"}));
        }
        return new ClusterManager(provider, dir, MapUtil.stringMap((String[])new String[0]), instanceConfig);
    }

    private long createNodeWithPropertyOn(HighlyAvailableGraphDatabase db, String property, String value) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            node.setProperty(property, (Object)value);
            tx.success();
            long l = node.getId();
            return l;
        }
    }

    private CountDownLatch createMasterFailLatch(ClusterManager.ManagedCluster cluster) {
        final CountDownLatch failedLatch = new CountDownLatch(2);
        for (HighlyAvailableGraphDatabase db : cluster.getAllMembers()) {
            if (db.isMaster()) continue;
            ((ClusterClient)db.getDependencyResolver().resolveDependency(ClusterClient.class)).addHeartbeatListener(new HeartbeatListener(){

                public void failed(InstanceId server) {
                    failedLatch.countDown();
                }

                public void alive(InstanceId server) {
                }
            });
        }
        return failedLatch;
    }
}

