/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.HighAvailabilityModeSwitcher;
import org.neo4j.kernel.ha.cluster.SwitchToMaster;
import org.neo4j.kernel.ha.cluster.SwitchToSlave;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;

public class HighAvailabilityModeSwitcherTest {
    @Test
    public void shouldBroadcastMasterIsAvailableIfMasterAndReceiveMasterIsElected() throws Exception {
        ClusterMemberAvailability availability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        HighAvailabilityModeSwitcher toTest = new HighAvailabilityModeSwitcher((SwitchToSlave)Mockito.mock(SwitchToSlave.class), (SwitchToMaster)Mockito.mock(SwitchToMaster.class), (Election)Mockito.mock(Election.class), availability, HighAvailabilityModeSwitcherTest.dependencyResolverMock(), (Logging)new DevNullLoggingService());
        toTest.masterIsElected(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.MASTER, HighAvailabilityMemberState.MASTER, new InstanceId(2), URI.create("ha://someone")));
        ((ClusterMemberAvailability)Mockito.verify((Object)availability)).memberIsAvailable("master", null, StoreId.DEFAULT);
    }

    @Test
    public void shouldBroadcastSlaveIsAvailableIfSlaveAndReceivesMasterIsAvailable() throws Exception {
        ClusterMemberAvailability availability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        HighAvailabilityModeSwitcher toTest = new HighAvailabilityModeSwitcher((SwitchToSlave)Mockito.mock(SwitchToSlave.class), (SwitchToMaster)Mockito.mock(SwitchToMaster.class), (Election)Mockito.mock(Election.class), availability, HighAvailabilityModeSwitcherTest.dependencyResolverMock(), (Logging)new DevNullLoggingService());
        toTest.masterIsAvailable(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.SLAVE, HighAvailabilityMemberState.SLAVE, new InstanceId(2), URI.create("ha://someone")));
        ((ClusterMemberAvailability)Mockito.verify((Object)availability)).memberIsAvailable("slave", null, StoreId.DEFAULT);
    }

    @Test
    public void shouldNotBroadcastIfSlaveAndReceivesMasterIsElected() throws Exception {
        ClusterMemberAvailability availability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        HighAvailabilityModeSwitcher toTest = new HighAvailabilityModeSwitcher((SwitchToSlave)Mockito.mock(SwitchToSlave.class), (SwitchToMaster)Mockito.mock(SwitchToMaster.class), (Election)Mockito.mock(Election.class), availability, HighAvailabilityModeSwitcherTest.dependencyResolverMock(), (Logging)new DevNullLoggingService());
        toTest.masterIsElected(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.SLAVE, HighAvailabilityMemberState.SLAVE, new InstanceId(2), URI.create("ha://someone")));
        Mockito.verifyZeroInteractions((Object[])new Object[]{availability});
    }

    @Test
    public void shouldNotBroadcastIfMasterAndReceivesSlaveIsAvailable() throws Exception {
        ClusterMemberAvailability availability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        HighAvailabilityModeSwitcher toTest = new HighAvailabilityModeSwitcher((SwitchToSlave)Mockito.mock(SwitchToSlave.class), (SwitchToMaster)Mockito.mock(SwitchToMaster.class), (Election)Mockito.mock(Election.class), availability, HighAvailabilityModeSwitcherTest.dependencyResolverMock(), (Logging)new DevNullLoggingService());
        toTest.slaveIsAvailable(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.MASTER, HighAvailabilityMemberState.MASTER, new InstanceId(2), URI.create("ha://someone")));
        Mockito.verifyZeroInteractions((Object[])new Object[]{availability});
    }

    @Test
    public void shouldReswitchToSlaveIfNewMasterBecameAvailableDuringSwitch() throws Throwable {
        final CountDownLatch switching = new CountDownLatch(1);
        final CountDownLatch slaveAvailable = new CountDownLatch(2);
        final AtomicBoolean firstSwitch = new AtomicBoolean(true);
        ClusterMemberAvailability availability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        SwitchToSlave switchToSlave = (SwitchToSlave)Mockito.mock(SwitchToSlave.class);
        SwitchToMaster switchToMaster = (SwitchToMaster)Mockito.mock(SwitchToMaster.class);
        Mockito.when((Object)switchToSlave.switchToSlave((LifeSupport)Matchers.any(LifeSupport.class), (URI)Matchers.any(URI.class), (URI)Matchers.any(URI.class), (CancellationRequest)Matchers.any(CancellationRequest.class))).thenAnswer((Answer)new Answer<URI>(){

            public URI answer(InvocationOnMock invocationOnMock) throws Throwable {
                switching.countDown();
                CancellationRequest cancel = (CancellationRequest)invocationOnMock.getArguments()[3];
                if (firstSwitch.get()) {
                    while (!cancel.cancellationRequested()) {
                        Thread.sleep(1L);
                    }
                    firstSwitch.set(false);
                }
                slaveAvailable.countDown();
                return URI.create("ha://slave");
            }
        });
        Logging logging = (Logging)Mockito.mock(Logging.class);
        ((Logging)Mockito.doReturn((Object)new ConsoleLogger(StringLogger.DEV_NULL)).when((Object)logging)).getConsoleLog(HighAvailabilityModeSwitcher.class);
        HighAvailabilityModeSwitcher toTest = new HighAvailabilityModeSwitcher(switchToSlave, switchToMaster, (Election)Mockito.mock(Election.class), availability, HighAvailabilityModeSwitcherTest.dependencyResolverMock(), (Logging)new DevNullLoggingService());
        toTest.init();
        toTest.start();
        toTest.listeningAt(URI.create("ha://server3?serverId=3"));
        toTest.masterIsAvailable(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.PENDING, HighAvailabilityMemberState.TO_SLAVE, new InstanceId(1), URI.create("ha://server1")));
        switching.await();
        toTest.masterIsElected(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.TO_SLAVE, HighAvailabilityMemberState.PENDING, new InstanceId(2), URI.create("ha://server2")));
        toTest.masterIsAvailable(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.PENDING, HighAvailabilityMemberState.TO_SLAVE, new InstanceId(2), URI.create("ha://server2")));
        slaveAvailable.await();
    }

    @Test
    public void shouldTakeNoActionIfSwitchingToSlaveForItselfAsMaster() throws Throwable {
        SwitchToSlave switchToSlave = (SwitchToSlave)Mockito.mock(SwitchToSlave.class);
        Logging logging = (Logging)Mockito.mock(Logging.class);
        StringLogger msgLog = (StringLogger)Mockito.mock(StringLogger.class);
        Mockito.when((Object)logging.getMessagesLog(HighAvailabilityModeSwitcher.class)).thenReturn((Object)msgLog);
        HighAvailabilityModeSwitcher toTest = new HighAvailabilityModeSwitcher(switchToSlave, (SwitchToMaster)Mockito.mock(SwitchToMaster.class), (Election)Mockito.mock(Election.class), (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class), HighAvailabilityModeSwitcherTest.dependencyResolverMock(), logging);
        toTest.init();
        toTest.start();
        URI serverHaUri = URI.create("ha://server2?serverId=2");
        toTest.listeningAt(serverHaUri);
        toTest.masterIsAvailable(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.PENDING, HighAvailabilityMemberState.TO_SLAVE, new InstanceId(2), serverHaUri));
        Mockito.verifyZeroInteractions((Object[])new Object[]{switchToSlave});
        ((StringLogger)Mockito.verify((Object)msgLog, (VerificationMode)Mockito.times((int)1))).error(Matchers.anyString());
    }

    @Test
    public void shouldPerformForcedElections() {
        ClusterMemberAvailability memberAvailability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityModeSwitcher modeSwitcher = new HighAvailabilityModeSwitcher((SwitchToSlave)Mockito.mock(SwitchToSlave.class), (SwitchToMaster)Mockito.mock(SwitchToMaster.class), election, memberAvailability, HighAvailabilityModeSwitcherTest.dependencyResolverMock(), (Logging)new DevNullLoggingService());
        modeSwitcher.forceElections();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{memberAvailability, election});
        ((ClusterMemberAvailability)inOrder.verify((Object)memberAvailability)).memberIsUnavailable("slave");
        ((Election)inOrder.verify((Object)election)).performRoleElections();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void shouldPerformForcedElectionsOnlyOnce() {
        ClusterMemberAvailability memberAvailability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        Election election = (Election)Mockito.mock(Election.class);
        HighAvailabilityModeSwitcher modeSwitcher = new HighAvailabilityModeSwitcher((SwitchToSlave)Mockito.mock(SwitchToSlave.class), (SwitchToMaster)Mockito.mock(SwitchToMaster.class), election, memberAvailability, HighAvailabilityModeSwitcherTest.dependencyResolverMock(), (Logging)new DevNullLoggingService());
        modeSwitcher.forceElections();
        modeSwitcher.forceElections();
        modeSwitcher.forceElections();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{memberAvailability, election});
        ((ClusterMemberAvailability)inOrder.verify((Object)memberAvailability)).memberIsUnavailable("slave");
        ((Election)inOrder.verify((Object)election)).performRoleElections();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void shouldAllowForcedElectionsAfterModeSwitch() throws Throwable {
        SwitchToSlave switchToSlave = (SwitchToSlave)Mockito.mock(SwitchToSlave.class);
        Mockito.when((Object)switchToSlave.switchToSlave((LifeSupport)Matchers.any(LifeSupport.class), (URI)Matchers.any(URI.class), (URI)Matchers.any(URI.class), (CancellationRequest)Matchers.any(CancellationRequest.class))).thenReturn((Object)URI.create("http://localhost"));
        ClusterMemberAvailability memberAvailability = (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class);
        Election election = (Election)Mockito.mock(Election.class);
        final CountDownLatch modeSwitchHappened = new CountDownLatch(1);
        HighAvailabilityModeSwitcher modeSwitcher = new HighAvailabilityModeSwitcher(switchToSlave, (SwitchToMaster)Mockito.mock(SwitchToMaster.class), election, memberAvailability, HighAvailabilityModeSwitcherTest.dependencyResolverMock(), (Logging)new DevNullLoggingService()){

            ScheduledExecutorService createExecutor() {
                ScheduledExecutorService executor = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
                ((ScheduledExecutorService)Mockito.doAnswer((Answer)new Answer(){

                    public Object answer(InvocationOnMock invocation) throws Throwable {
                        ((Runnable)invocation.getArguments()[0]).run();
                        modeSwitchHappened.countDown();
                        return Mockito.mock(Future.class);
                    }
                }).when((Object)executor)).submit((Runnable)Matchers.any(Runnable.class));
                return executor;
            }
        };
        modeSwitcher.init();
        modeSwitcher.start();
        modeSwitcher.forceElections();
        Mockito.reset((Object[])new Object[]{memberAvailability, election});
        modeSwitcher.masterIsAvailable(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.PENDING, HighAvailabilityMemberState.TO_SLAVE, new InstanceId(1), URI.create("http://localhost:9090?serverId=42")));
        modeSwitchHappened.await();
        modeSwitcher.forceElections();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{memberAvailability, election});
        ((ClusterMemberAvailability)inOrder.verify((Object)memberAvailability)).memberIsUnavailable("slave");
        ((Election)inOrder.verify((Object)election)).performRoleElections();
        inOrder.verifyNoMoreInteractions();
    }

    private static DependencyResolver dependencyResolverMock() {
        DependencyResolver resolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        Mockito.when((Object)resolver.resolveDependency((Class)Matchers.eq(StoreId.class))).thenReturn((Object)StoreId.DEFAULT);
        return resolver;
    }
}

