/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.ha;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public class ClusterRule
extends ExternalResource {
    private final Class<?> testClass;
    private ClusterManager clusterManager;
    private File storeDirectory;
    private Description description;
    private ClusterManager.Provider provider = ClusterManager.clusterOfSize(3);
    private final Map<String, String> config = new HashMap<String, String>();
    private HighlyAvailableGraphDatabaseFactory factory = new HighlyAvailableGraphDatabaseFactory();
    private List<Predicate<ClusterManager.ManagedCluster>> availabilityChecks = Arrays.asList(ClusterManager.allSeesAllAsAvailable());

    public ClusterRule(Class<?> testClass) {
        this.testClass = testClass;
        this.config.putAll(MapUtil.stringMap((String[])new String[]{ClusterSettings.default_timeout.name(), "1s", HaSettings.tx_push_factor.name(), "0"}));
    }

    public ClusterRule config(Setting<?> setting, String value) {
        this.config.put(setting.name(), value);
        return this;
    }

    public ClusterRule provider(ClusterManager.Provider provider) {
        this.provider = provider;
        return this;
    }

    public ClusterRule factory(HighlyAvailableGraphDatabaseFactory factory) {
        this.factory = factory;
        return this;
    }

    public ClusterRule availabilityChecks(List<Predicate<ClusterManager.ManagedCluster>> checks) {
        this.availabilityChecks = new ArrayList<Predicate<ClusterManager.ManagedCluster>>(checks);
        return this;
    }

    public ClusterManager.ManagedCluster startCluster() throws Exception {
        this.clusterManager = new ClusterManager.Builder(this.storeDirectory).withCommonConfig(this.config).withProvider(this.provider).withDbFactory(this.factory).build();
        try {
            this.clusterManager.start();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        ClusterManager.ManagedCluster cluster = this.clusterManager.getDefaultCluster();
        for (Predicate<ClusterManager.ManagedCluster> availabilityCheck : this.availabilityChecks) {
            cluster.await(availabilityCheck);
        }
        return cluster;
    }

    public Statement apply(Statement base, Description description) {
        this.description = description;
        return super.apply(base, description);
    }

    protected void before() throws Throwable {
        this.storeDirectory = TargetDirectory.forTest(this.testClass).directoryForDescription(this.description);
    }

    protected void after() {
        try {
            if (this.clusterManager != null) {
                this.clusterManager.shutdown();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

