/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.lucene.store.LockObtainFailedException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.impl.index.LuceneLabelScanStore;
import org.neo4j.kernel.api.impl.index.LuceneLabelScanStoreExtension;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.ha.ClusterManager;

public class LabelScanStoreHaIT {
    private final File rootDirectory = TargetDirectory.forTest(this.getClass()).cleanDirectory("root");
    private ClusterManager clusterManager;
    private final LifeSupport life = new LifeSupport();
    private ClusterManager.ManagedCluster cluster;
    private final TestMonitor monitor = new TestMonitor();

    @Test
    public void shouldCopyLabelScanStoreToNewSlaves() throws Exception {
        Assert.assertTrue((this.monitor.callsTo_init >= 3 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Expected noone to build their label scan store index.", (long)0L, (long)this.monitor.timesRebuiltWithData);
        for (GraphDatabaseService graphDatabaseService : this.cluster.getAllMembers()) {
            Assert.assertEquals((long)2L, (long)this.numberOfNodesHavingLabel(graphDatabaseService, Labels.First));
            Assert.assertEquals((long)2L, (long)this.numberOfNodesHavingLabel(graphDatabaseService, Labels.First));
        }
    }

    private int numberOfNodesHavingLabel(GraphDatabaseService db, Label label) {
        try (Transaction tx = db.beginTx();){
            int count = IteratorUtil.count((Iterator)db.findNodes(label));
            tx.success();
            int n = count;
            return n;
        }
    }

    private void createSomeLabeledNodes(GraphDatabaseService db, Label[] ... labelArrays) {
        try (Transaction tx = db.beginTx();){
            for (Label[] labels : labelArrays) {
                db.createNode(labels);
            }
            tx.success();
        }
    }

    @Before
    public void setup() {
        LuceneLabelScanStoreExtension testExtension = new LuceneLabelScanStoreExtension(100, (LuceneLabelScanStore.Monitor)this.monitor);
        TestHighlyAvailableGraphDatabaseFactory factory = new TestHighlyAvailableGraphDatabaseFactory();
        factory.addKernelExtensions(Arrays.asList(testExtension));
        this.clusterManager = new ClusterManager.Builder(this.rootDirectory).withDbFactory(factory).withStoreDirInitializer(new ClusterManager.StoreDirInitializer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initializeStoreDir(int serverId, File storeDir) throws IOException {
                if (serverId == 1) {
                    GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir.getAbsolutePath());
                    try {
                        LabelScanStoreHaIT.this.createSomeLabeledNodes(db, new Label[][]{{Labels.First}, {Labels.First, Labels.Second}, {Labels.Second}});
                    }
                    finally {
                        db.shutdown();
                    }
                }
            }
        }).build();
        this.life.add((Object)this.clusterManager);
        this.life.start();
        this.cluster = this.clusterManager.getDefaultCluster();
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        this.cluster.await(ClusterManager.allAvailabilityGuardsReleased());
    }

    @After
    public void teardown() {
        this.life.shutdown();
    }

    private static class TestMonitor
    implements LuceneLabelScanStore.Monitor {
        private volatile int callsTo_init;
        private volatile int timesRebuiltWithData;

        private TestMonitor() {
        }

        public void init() {
            ++this.callsTo_init;
        }

        public void noIndex() {
        }

        public void lockedIndex(LockObtainFailedException e) {
        }

        public void corruptIndex(IOException e) {
        }

        public void rebuilding() {
        }

        public void rebuilt(long roughNodeCount) {
            if (roughNodeCount > 0L) {
                ++this.timesRebuiltWithData;
            }
        }
    }

    private static enum Labels implements Label
    {
        First,
        Second;

    }
}

