/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.io.File;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.neo4j.backup.OnlineBackupKernelExtension;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.com.Response;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.com.storecopy.TransactionCommittingResponseUnpacker;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.StoreLockerLifecycleAdapter;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.BranchedDataException;
import org.neo4j.kernel.ha.BranchedDataPolicy;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.cluster.SwitchToSlave;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.com.slave.MasterClientResolver;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.StoreCopyMonitor;

public class SwitchToSlaveTest {
    @Test
    public void shouldHandleBranchedStoreWhenMyStoreIdDiffersFromMasterStoreId() throws Throwable {
        SwitchToSlave switchToSlave = SwitchToSlaveTest.newSwitchToSlaveSpy();
        MasterClient masterClient = (MasterClient)Mockito.mock(MasterClient.class);
        Response response = (Response)Mockito.mock(Response.class);
        Mockito.when((Object)response.response()).thenReturn((Object)new HandshakeResult(1L, 2L));
        Mockito.when((Object)masterClient.handshake(Matchers.anyLong(), (StoreId)Matchers.any(StoreId.class))).thenReturn((Object)response);
        NeoStoreDataSource dataSource = SwitchToSlaveTest.dataSourceMock();
        Mockito.when((Object)dataSource.getStoreId()).thenReturn((Object)new StoreId(1L, 2L, 3L, 4L));
        try {
            switchToSlave.checkDataConsistency(masterClient, dataSource, null, false);
            Assert.fail((String)("Should have thrown " + MismatchingStoreIdException.class.getSimpleName() + " exception"));
        }
        catch (MismatchingStoreIdException e) {
            // empty catch block
        }
        ((SwitchToSlave)Mockito.verify((Object)switchToSlave)).stopServicesAndHandleBranchedStore((BranchedDataPolicy)Matchers.any(BranchedDataPolicy.class));
    }

    @Test
    public void shouldHandleBranchedStoreWhenHandshakeFailsWithBranchedDataException() throws Throwable {
        SwitchToSlave switchToSlave = SwitchToSlaveTest.newSwitchToSlaveSpy();
        MasterClient masterClient = (MasterClient)Mockito.mock(MasterClient.class);
        Mockito.when((Object)masterClient.handshake(Matchers.anyLong(), (StoreId)Matchers.any(StoreId.class))).thenThrow(new Throwable[]{new BranchedDataException("")});
        try {
            switchToSlave.checkDataConsistency(masterClient, SwitchToSlaveTest.dataSourceMock(), null, true);
            Assert.fail((String)("Should have thrown " + BranchedDataException.class.getSimpleName() + " exception"));
        }
        catch (BranchedDataException branchedDataException) {
            // empty catch block
        }
        ((SwitchToSlave)Mockito.verify((Object)switchToSlave)).stopServicesAndHandleBranchedStore((BranchedDataPolicy)Matchers.any(BranchedDataPolicy.class));
    }

    private static SwitchToSlave newSwitchToSlaveSpy() {
        return (SwitchToSlave)Mockito.spy((Object)new SwitchToSlave(ConsoleLogger.DEV_NULL, SwitchToSlaveTest.configMock(), SwitchToSlaveTest.dependencyResolverMock(), (HaIdGeneratorFactory)Mockito.mock(HaIdGeneratorFactory.class), (Logging)new DevNullLoggingService(), (DelegateInvocationHandler)Mockito.mock(DelegateInvocationHandler.class), (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class), (RequestContextFactory)Mockito.mock(RequestContextFactory.class), Iterables.empty(), (MasterClientResolver)Mockito.mock(MasterClientResolver.class), ByteCounterMonitor.NULL, (RequestMonitor)Mockito.mock(RequestMonitor.class), (SwitchToSlave.Monitor)Mockito.mock(SwitchToSlave.Monitor.class), StoreCopyMonitor.NONE));
    }

    private static NeoStoreDataSource dataSourceMock() {
        NeoStoreDataSource dataSource = (NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class);
        DependencyResolver dependencyResolver = SwitchToSlaveTest.dependencyResolverMock();
        Mockito.when((Object)dataSource.getDependencyResolver()).thenReturn((Object)dependencyResolver);
        return dataSource;
    }

    private static Config configMock() {
        Config config = (Config)Mockito.mock(Config.class);
        Mockito.when((Object)config.get(HaSettings.branched_data_policy)).thenReturn(Mockito.mock(BranchedDataPolicy.class));
        Mockito.when((Object)config.get(InternalAbstractGraphDatabase.Configuration.store_dir)).thenReturn(Mockito.mock(File.class));
        return config;
    }

    private static DependencyResolver dependencyResolverMock() {
        DependencyResolver resolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        Mockito.when((Object)resolver.resolveDependency(StoreLockerLifecycleAdapter.class)).thenReturn((Object)SwitchToSlaveTest.mockWithLifecycle(StoreLockerLifecycleAdapter.class));
        Mockito.when((Object)resolver.resolveDependency(NeoStoreDataSource.class)).thenReturn((Object)SwitchToSlaveTest.mockWithLifecycle(NeoStoreDataSource.class));
        Mockito.when((Object)resolver.resolveDependency(RequestContextFactory.class)).thenReturn((Object)SwitchToSlaveTest.mockWithLifecycle(RequestContextFactory.class));
        Mockito.when((Object)resolver.resolveDependency(TransactionCommittingResponseUnpacker.class)).thenReturn((Object)SwitchToSlaveTest.mockWithLifecycle(TransactionCommittingResponseUnpacker.class));
        Mockito.when((Object)resolver.resolveDependency(IndexConfigStore.class)).thenReturn((Object)SwitchToSlaveTest.mockWithLifecycle(IndexConfigStore.class));
        Mockito.when((Object)resolver.resolveDependency(OnlineBackupKernelExtension.class)).thenReturn((Object)SwitchToSlaveTest.mockWithLifecycle(OnlineBackupKernelExtension.class));
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)transactionIdStore.getLastCommittedTransaction()).thenReturn((Object)new long[]{42L, 42L});
        Mockito.when((Object)transactionIdStore.getLastCommittedTransactionId()).thenReturn((Object)1L);
        Mockito.when((Object)resolver.resolveDependency(TransactionIdStore.class)).thenReturn((Object)transactionIdStore);
        ClusterMembers clusterMembers = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        ClusterMember master = (ClusterMember)Mockito.mock(ClusterMember.class);
        Mockito.when((Object)master.getStoreId()).thenReturn((Object)new StoreId(42L, 42L, 42L, 42L));
        Mockito.when((Object)master.getHARole()).thenReturn((Object)"master");
        Mockito.when((Object)master.hasRole((String)Matchers.eq((Object)"master"))).thenReturn((Object)true);
        Mockito.when((Object)clusterMembers.getMembers()).thenReturn(Arrays.asList(master));
        Mockito.when((Object)resolver.resolveDependency(ClusterMembers.class)).thenReturn((Object)clusterMembers);
        return resolver;
    }

    private static <T> T mockWithLifecycle(Class<T> clazz) {
        return (T)Mockito.mock(clazz, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Lifecycle.class}));
    }
}

