/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.neo4j.cluster.InstanceId;
import org.neo4j.com.storecopy.TransactionObligationFulfiller;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class UpdatePullingTransactionObligationFulfiller
extends LifecycleAdapter
implements TransactionObligationFulfiller {
    private final UpdatePuller updatePuller;
    private final RoleListener listener;
    private final DependencyResolver resolver;
    private TransactionIdStore transactionIdStore;
    private final HighAvailabilityMemberStateMachine memberStateMachine;

    public UpdatePullingTransactionObligationFulfiller(UpdatePuller updatePuller, HighAvailabilityMemberStateMachine memberStateMachine, InstanceId serverId, DependencyResolver resolver) {
        this.updatePuller = updatePuller;
        this.memberStateMachine = memberStateMachine;
        this.resolver = resolver;
        this.listener = new RoleListener(serverId);
    }

    public void fulfill(final long toTxId) throws InterruptedException {
        this.updatePuller.await(new UpdatePuller.Condition(){

            @Override
            public boolean evaluate(int currentTicket, int targetTicket) {
                return UpdatePullingTransactionObligationFulfiller.this.transactionIdStore.getLastClosedTransactionId() >= toTxId;
            }
        }, true);
    }

    public void start() throws Throwable {
        this.memberStateMachine.addHighAvailabilityMemberListener(this.listener);
    }

    public void stop() throws Throwable {
        this.memberStateMachine.removeHighAvailabilityMemberListener(this.listener);
    }

    private class RoleListener
    extends HighAvailabilityMemberListener.Adapter {
        private final InstanceId myInstanceId;

        private RoleListener(InstanceId myInstanceId) {
            this.myInstanceId = myInstanceId;
        }

        @Override
        public void slaveIsAvailable(HighAvailabilityMemberChangeEvent event) {
            if (event.getInstanceId().equals((Object)this.myInstanceId)) {
                UpdatePullingTransactionObligationFulfiller.this.transactionIdStore = (TransactionIdStore)UpdatePullingTransactionObligationFulfiller.this.resolver.resolveDependency(TransactionIdStore.class);
            }
        }
    }
}

