/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.management;

import java.io.File;
import java.util.LinkedList;
import javax.management.NotCompliantMBeanException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.ha.BranchedDataPolicy;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.management.BranchedStore;
import org.neo4j.management.BranchedStoreInfo;

public final class BranchedStoreBean
extends ManagementBeanProvider {
    public BranchedStoreBean() {
        super(BranchedStore.class);
    }

    protected Neo4jMBean createMXBean(ManagementData management) throws NotCompliantMBeanException {
        if (!BranchedStoreBean.isHA(management)) {
            return null;
        }
        return new BranchedStoreImpl(management, true);
    }

    protected Neo4jMBean createMBean(ManagementData management) throws NotCompliantMBeanException {
        if (!BranchedStoreBean.isHA(management)) {
            return null;
        }
        return new BranchedStoreImpl(management);
    }

    private static boolean isHA(ManagementData management) {
        return management.getKernelData().graphDatabase() instanceof HighlyAvailableGraphDatabase;
    }

    private static class BranchedStoreImpl
    extends Neo4jMBean
    implements BranchedStore {
        private final File storePath;

        protected BranchedStoreImpl(ManagementData management) throws NotCompliantMBeanException {
            super(management, new String[0]);
            this.storePath = this.getStorePath(management);
        }

        protected BranchedStoreImpl(ManagementData management, boolean isMXBean) {
            super(management, isMXBean, new String[0]);
            this.storePath = this.getStorePath(management);
        }

        public BranchedStoreInfo[] getBranchedStores() {
            if (this.storePath == null) {
                return new BranchedStoreInfo[0];
            }
            LinkedList<BranchedStoreInfo> toReturn = new LinkedList<BranchedStoreInfo>();
            for (File branchDirectory : BranchedDataPolicy.getBranchedDataRootDirectory(this.storePath).listFiles()) {
                if (!branchDirectory.isDirectory()) continue;
                toReturn.add(this.parseBranchedStore(branchDirectory));
            }
            return toReturn.toArray(new BranchedStoreInfo[toReturn.size()]);
        }

        private BranchedStoreInfo parseBranchedStore(File branchDirectory) {
            File neoStoreFile = new File(branchDirectory, "neostore");
            long txId = NeoStore.getRecord((FileSystemAbstraction)new DefaultFileSystemAbstraction(), (File)neoStoreFile, (NeoStore.Position)NeoStore.Position.LAST_TRANSACTION_ID);
            long timestamp = Long.parseLong(branchDirectory.getName());
            return new BranchedStoreInfo(branchDirectory.getName(), txId, timestamp);
        }

        private File getStorePath(ManagementData management) {
            return (File)management.getKernelData().getConfig().get(InternalAbstractGraphDatabase.Configuration.store_dir);
        }
    }
}

