/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatListener;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

@Ignore(value="To be rewritten")
public class QuorumWritesIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterStopsWritesWhenMajorityIsUnavailable() throws Throwable {
        File root = TargetDirectory.forTest(this.getClass()).cleanDirectory("testMasterStopsWritesWhenMajorityIsUnavailable");
        ClusterManager clusterManager = new ClusterManager(ClusterManager.clusterOfSize(3), root, MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_factor.name(), "2", HaSettings.state_switch_timeout.name(), "5s"}));
        try {
            clusterManager.start();
            ClusterManager.ManagedCluster cluster = clusterManager.getDefaultCluster();
            cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
            cluster.await(ClusterManager.masterSeesAllSlavesAsAvailable());
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            this.doTx(master);
            CountDownLatch latch1 = new CountDownLatch(1);
            this.waitOnHeartbeatFail(master, latch1);
            HighlyAvailableGraphDatabase slave1 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
            cluster.fail(slave1);
            latch1.await();
            slave1.shutdown();
            this.doTx(master);
            CountDownLatch latch2 = new CountDownLatch(1);
            this.waitOnHeartbeatFail(master, latch2);
            HighlyAvailableGraphDatabase slave2 = cluster.getAnySlave(slave1);
            ClusterManager.RepairKit rk2 = cluster.fail(slave2);
            latch2.await();
            Assert.assertFalse((boolean)master.isMaster());
            try {
                this.doTx(master);
                Assert.fail((String)"After both slaves fail txs should not go through");
            }
            catch (TransactionFailureException e) {
                Assert.assertEquals((Object)"Timeout waiting for cluster to elect master", (Object)e.getMessage());
            }
            Thread.sleep(120000L);
            CountDownLatch latch3 = new CountDownLatch(1);
            CountDownLatch latch4 = new CountDownLatch(1);
            CountDownLatch latch5 = new CountDownLatch(1);
            this.waitOnHeartbeatAlive(master, latch3);
            this.waitOnRoleIsAvailable(master, latch5, "slave");
            rk2.repair();
            latch3.await();
            cluster.await(ClusterManager.masterAvailable(slave1, slave2));
            latch5.await();
            cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
            Assert.assertTrue((boolean)master.isMaster());
            Assert.assertFalse((boolean)slave2.isMaster());
            Node finalNode = this.doTx(master);
            try (Transaction transaction = slave2.beginTx();){
                slave2.getNodeById(finalNode.getId());
                transaction.success();
            }
        }
        finally {
            clusterManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInstanceCanBeReplacedToReestablishQuorum() throws Throwable {
        File root = TargetDirectory.forTest(this.getClass()).cleanDirectory("testInstanceCanBeReplacedToReestablishQuorum");
        ClusterManager clusterManager = new ClusterManager(ClusterManager.clusterOfSize(3), root, MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_factor.name(), "2", HaSettings.state_switch_timeout.name(), "5s"}));
        clusterManager.start();
        ClusterManager.ManagedCluster cluster = clusterManager.getDefaultCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        cluster.await(ClusterManager.masterSeesAllSlavesAsAvailable());
        this.doTx(master);
        CountDownLatch latch1 = new CountDownLatch(1);
        this.waitOnHeartbeatFail(master, latch1);
        HighlyAvailableGraphDatabase slave1 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        cluster.fail(slave1);
        latch1.await();
        slave1.shutdown();
        this.doTx(master);
        CountDownLatch latch2 = new CountDownLatch(1);
        this.waitOnHeartbeatFail(master, latch2);
        HighlyAvailableGraphDatabase slave2 = cluster.getAnySlave(slave1);
        cluster.fail(slave2);
        latch2.await();
        Assert.assertFalse((boolean)master.isMaster());
        try {
            this.doTx(master);
            Assert.fail((String)"After both slaves fail txs should not go through");
        }
        catch (TransactionFailureException e) {
            Assert.assertEquals((Object)"Timeout waiting for cluster to elect master", (Object)e.getMessage());
        }
        Thread.sleep(120000L);
        CountDownLatch latch3 = new CountDownLatch(1);
        CountDownLatch latch4 = new CountDownLatch(1);
        CountDownLatch latch5 = new CountDownLatch(1);
        this.waitOnHeartbeatAlive(master, latch3);
        this.waitOnRoleIsAvailable(master, latch4, "master");
        this.waitOnRoleIsAvailable(master, latch5, "slave");
        HighlyAvailableGraphDatabase replacement = (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(new File(root, "replacement").getAbsolutePath()).setConfig(ClusterSettings.cluster_server, ":5010").setConfig(HaSettings.ha_server, ":6010").setConfig(ClusterSettings.server_id, "3").setConfig(ClusterSettings.initial_hosts, cluster.getInitialHostsConfigString()).setConfig(HaSettings.tx_push_factor, "0").newGraphDatabase();
        latch3.await();
        latch4.await();
        latch5.await();
        Assert.assertTrue((boolean)master.isMaster());
        Assert.assertFalse((boolean)replacement.isMaster());
        Node finalNode = this.doTx(master);
        Transaction transaction = replacement.beginTx();
        try {
            replacement.getNodeById(finalNode.getId());
        }
        finally {
            transaction.finish();
        }
        clusterManager.stop();
        replacement.shutdown();
    }

    private void waitOnHeartbeatFail(HighlyAvailableGraphDatabase master, final CountDownLatch latch) {
        final ClusterClient clusterClient = (ClusterClient)master.getDependencyResolver().resolveDependency(ClusterClient.class);
        clusterClient.addHeartbeatListener((HeartbeatListener)new HeartbeatListener.Adapter(){

            public void failed(InstanceId server) {
                latch.countDown();
                clusterClient.removeHeartbeatListener((HeartbeatListener)this);
            }
        });
    }

    private void waitOnHeartbeatAlive(HighlyAvailableGraphDatabase master, final CountDownLatch latch) {
        final ClusterClient clusterClient = (ClusterClient)master.getDependencyResolver().resolveDependency(ClusterClient.class);
        clusterClient.addHeartbeatListener((HeartbeatListener)new HeartbeatListener.Adapter(){

            public void alive(InstanceId server) {
                latch.countDown();
                clusterClient.removeHeartbeatListener((HeartbeatListener)this);
            }
        });
    }

    private void waitOnRoleIsAvailable(HighlyAvailableGraphDatabase master, final CountDownLatch latch, final String roleToWaitFor) {
        final ClusterMemberEvents events = (ClusterMemberEvents)master.getDependencyResolver().resolveDependency(ClusterMemberEvents.class);
        events.addClusterMemberListener((ClusterMemberListener)new ClusterMemberListener.Adapter(){

            public void memberIsAvailable(String role, InstanceId availableId, URI atUri, StoreId storeId) {
                if (role.equals(roleToWaitFor)) {
                    latch.countDown();
                    events.removeClusterMemberListener((ClusterMemberListener)this);
                }
            }
        });
    }

    private Node doTx(HighlyAvailableGraphDatabase db) {
        Transaction tx = db.beginTx();
        Node node = db.createNode();
        tx.success();
        tx.finish();
        return node;
    }
}

