/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.com.RequestContext;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TransactionStreamResponse;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.ha.lock.LockStatus;
import org.neo4j.kernel.ha.lock.SlaveLockManager;
import org.neo4j.kernel.ha.lock.SlaveLocksClient;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;

public class SlaveLocksClientTest {
    private SlaveLocksClient client;
    private Master master;
    private Locks.Client local;

    @Before
    public void setUp() throws Exception {
        Locks lockManager = (Locks)Mockito.mock(Locks.class);
        this.master = (Master)Mockito.mock(Master.class);
        this.local = (Locks.Client)Mockito.mock(Locks.Client.class);
        Mockito.when((Object)this.local.tryExclusiveLock((Locks.ResourceType)Matchers.any(Locks.ResourceType.class), new long[]{(Long)Matchers.any(Long.TYPE)})).thenReturn((Object)true);
        Mockito.when((Object)this.local.trySharedLock((Locks.ResourceType)Matchers.any(Locks.ResourceType.class), new long[]{(Long)Matchers.any(Long.TYPE)})).thenReturn((Object)true);
        Mockito.when((Object)lockManager.newClient()).thenReturn((Object)this.local);
        RequestContextFactory requestContextFactory = (RequestContextFactory)Mockito.mock(RequestContextFactory.class);
        Mockito.when((Object)this.master.acquireSharedLock((RequestContext)Matchers.any(RequestContext.class), (Locks.ResourceType)Matchers.any(Locks.ResourceType.class), (long[])Matchers.anyVararg())).thenReturn((Object)new TransactionStreamResponse((Object)new LockResult(LockStatus.OK_LOCKED), null, TransactionStream.EMPTY, ResourceReleaser.NO_OP));
        Mockito.when((Object)this.master.acquireExclusiveLock((RequestContext)Matchers.any(RequestContext.class), (Locks.ResourceType)Matchers.any(Locks.ResourceType.class), (long[])Matchers.anyVararg())).thenReturn((Object)new TransactionStreamResponse((Object)new LockResult(LockStatus.OK_LOCKED), null, TransactionStream.EMPTY, ResourceReleaser.NO_OP));
        AvailabilityGuard availabilityGuard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        Mockito.when((Object)availabilityGuard.isAvailable(Matchers.anyLong())).thenReturn((Object)true);
        SlaveLockManager.Configuration config = (SlaveLockManager.Configuration)Mockito.mock(SlaveLockManager.Configuration.class);
        this.client = new SlaveLocksClient(this.master, this.local, lockManager, requestContextFactory, availabilityGuard, config);
    }

    @Test
    public void shouldNotTakeSharedLockOnMasterIfWeAreAlreadyHoldingSaidLock() {
        this.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        ((Master)Mockito.verify((Object)this.master)).acquireSharedLock(null, (Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
    }

    @Test
    public void shouldNotTakeSharedLockOnMasterIfWeAreAlreadyHoldingSaidLock_OverlappingBatch() {
        Mockito.when((Object)this.local.trySharedLock((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L, 2L})).thenReturn((Object)true);
        Mockito.when((Object)this.local.trySharedLock((Locks.ResourceType)ResourceTypes.NODE, new long[]{2L, 3L})).thenReturn((Object)true);
        this.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L, 2L});
        this.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{2L, 3L});
        ((Master)Mockito.verify((Object)this.master)).acquireSharedLock(null, (Locks.ResourceType)ResourceTypes.NODE, new long[]{1L, 2L});
        ((Master)Mockito.verify((Object)this.master)).acquireSharedLock(null, (Locks.ResourceType)ResourceTypes.NODE, new long[]{3L});
    }

    @Test
    public void shouldNotTakeExclusiveLockOnMasterIfWeAreAlreadyHoldingSaidLock() {
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        ((Master)Mockito.verify((Object)this.master)).acquireExclusiveLock(null, (Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
    }

    @Test
    public void shouldNotTakeExclusiveLockOnMasterIfWeAreAlreadyHoldingSaidLock_OverlappingBatch() {
        Mockito.when((Object)this.local.tryExclusiveLock((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L, 2L})).thenReturn((Object)true);
        Mockito.when((Object)this.local.tryExclusiveLock((Locks.ResourceType)ResourceTypes.NODE, new long[]{2L, 3L})).thenReturn((Object)true);
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L, 2L});
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{2L, 3L});
        ((Master)Mockito.verify((Object)this.master)).acquireExclusiveLock(null, (Locks.ResourceType)ResourceTypes.NODE, new long[]{1L, 2L});
        ((Master)Mockito.verify((Object)this.master)).acquireExclusiveLock(null, (Locks.ResourceType)ResourceTypes.NODE, new long[]{3L});
    }

    @Test
    public void shouldAllowAcquiringReleasingAndReacquiringExclusive() throws Exception {
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.client.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.client.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)2))).tryExclusiveLock((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)2))).releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
    }

    @Test
    public void shouldAllowAcquiringReleasingAndReacquiringShared() throws Exception {
        this.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.client.releaseShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.client.releaseShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)2))).trySharedLock((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)2))).releaseShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
    }

    @Test
    public void shouldNotTalkToLocalLocksOnReentrancyExclusive() throws Exception {
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.client.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)1))).tryExclusiveLock((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)0))).releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
    }

    @Test
    public void shouldNotTalkToLocalLocksOnReentrancyShared() throws Exception {
        this.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.client.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.client.releaseShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)1))).trySharedLock((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)0))).releaseShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
    }

    @Test
    public void shouldReturnNoLockSessionIfNotInitialized() throws Exception {
        int lockSessionId = this.client.getLockSessionId();
        MatcherAssert.assertThat((Object)lockSessionId, (Matcher)CoreMatchers.equalTo((Object)-1));
    }

    @Test
    public void shouldReturnDelegateIdIfInitialized() throws Exception {
        this.client.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        int lockSessionId = this.client.getLockSessionId();
        MatcherAssert.assertThat((Object)lockSessionId, (Matcher)CoreMatchers.equalTo((Object)0));
    }
}

