/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.ha.DelegateInvocationHandler;

public class DelegateInvocationHandlerTest {
    @Test
    public void shouldNotBeAbleToUseValueBeforeHardened() throws Exception {
        DelegateInvocationHandler handler = new DelegateInvocationHandler(Value.class);
        Value value = (Value)handler.cement();
        try {
            value.get();
            Assert.fail((String)"Should fail");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldBeAbleToUseCementedValueOnceDelegateSet() throws Exception {
        DelegateInvocationHandler handler = new DelegateInvocationHandler(Value.class);
        Value cementedValue = (Value)handler.cement();
        handler.setDelegate((Object)this.value(10));
        Assert.assertEquals((long)10L, (long)cementedValue.get());
    }

    @Test
    public void shouldBeAbleToUseCementedValueOnceHardened() throws Exception {
        DelegateInvocationHandler handler = new DelegateInvocationHandler(Value.class);
        Value cementedValue = (Value)handler.cement();
        handler.setDelegate((Object)this.value(10));
        Assert.assertEquals((long)10L, (long)cementedValue.get());
    }

    @Test
    public void setDelegateShouldBeAbleToOverridePreviousHarden() throws Exception {
        DelegateInvocationHandler handler = new DelegateInvocationHandler(Value.class);
        handler.setDelegate((Object)this.value(10));
        Value cementedValue = (Value)handler.cement();
        handler.harden();
        handler.setDelegate((Object)this.value(20));
        Assert.assertEquals((long)20L, (long)cementedValue.get());
    }

    private Value value(final int i) {
        return new Value(){

            @Override
            public int get() {
                return i;
            }
        };
    }

    private static interface Value {
        public int get();
    }
}

