/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.cache.HighPerformanceCacheSettings;
import org.neo4j.kernel.impl.core.Caches;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;

public class HaCaches
implements Caches {
    private CacheProvider type;
    private Config config;
    private Cache<NodeImpl> node;
    private Cache<RelationshipImpl> relationship;
    private final StringLogger logger;
    private final Monitors monitors;

    public HaCaches(StringLogger logger, Monitors monitors) {
        this.logger = logger;
        this.monitors = monitors;
    }

    public void configure(CacheProvider newType, Config config) {
        if (!this.cacheConfigSame(newType, config)) {
            this.node = newType.newNodeCache(this.logger, config, this.monitors);
            this.relationship = newType.newRelationshipCache(this.logger, config, this.monitors);
        } else {
            this.node.clear();
            this.relationship.clear();
        }
        this.type = newType;
        this.config = config;
    }

    private boolean cacheConfigSame(CacheProvider type, Config config) {
        return this.type != null && this.type.getName().equals(type.getName()) && "hpc".equals(this.type.getName()) && this.mySettingIsSameAs(config, HighPerformanceCacheSettings.node_cache_array_fraction) && this.mySettingIsSameAs(config, HighPerformanceCacheSettings.relationship_cache_array_fraction) && this.mySettingIsSameAs(config, HighPerformanceCacheSettings.node_cache_size) && this.mySettingIsSameAs(config, HighPerformanceCacheSettings.relationship_cache_size);
    }

    private boolean mySettingIsSameAs(Config otherConfig, Setting<?> setting) {
        Object myValue = this.config.get(setting);
        Object otherValue = otherConfig.get(setting);
        return myValue.equals(otherValue);
    }

    public Cache<NodeImpl> node() {
        return this.node;
    }

    public Cache<RelationshipImpl> relationship() {
        return this.relationship;
    }

    public void invalidate() {
        this.type = null;
        this.config = null;
    }

    public void clear() {
        this.node.clear();
        this.relationship.clear();
    }

    public CacheProvider getProvider() {
        return this.type;
    }
}

