/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Map;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.neo4j.cluster.BindingListener;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.com.BindingNotifier;
import org.neo4j.cluster.logging.NettyLoggerFactory;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.member.paxos.MemberIsAvailable;
import org.neo4j.cluster.member.paxos.PaxosClusterMemberAvailability;
import org.neo4j.cluster.member.paxos.PaxosClusterMemberEvents;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcast;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectInputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectOutputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectStreamFactory;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.NotElectableElectionCredentialsProvider;
import org.neo4j.cluster.protocol.heartbeat.Heartbeat;
import org.neo4j.cluster.protocol.snapshot.Snapshot;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.com.storecopy.StoreCopyClient;
import org.neo4j.com.storecopy.TransactionCommittingResponseUnpacker;
import org.neo4j.com.storecopy.TransactionObligationFulfiller;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Function2;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Provider;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.DatabaseAvailability;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.ha.BranchedDataMigrator;
import org.neo4j.kernel.ha.CommitProcessSwitcher;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaCaches;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighAvailabilityConsoleLogger;
import org.neo4j.kernel.ha.HighAvailabilityDiagnostics;
import org.neo4j.kernel.ha.HighAvailabilityMemberInfoProvider;
import org.neo4j.kernel.ha.LabelTokenCreatorModeSwitcher;
import org.neo4j.kernel.ha.LastUpdateTime;
import org.neo4j.kernel.ha.PropertyKeyCreatorModeSwitcher;
import org.neo4j.kernel.ha.PullerFactory;
import org.neo4j.kernel.ha.RelationshipTypeCreatorModeSwitcher;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.UpdatePullerModeSwitcher;
import org.neo4j.kernel.ha.cluster.DefaultElectionCredentialsProvider;
import org.neo4j.kernel.ha.cluster.HANewSnapshotFunction;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.cluster.HighAvailabilityModeSwitcher;
import org.neo4j.kernel.ha.cluster.SimpleHighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.SwitchToMaster;
import org.neo4j.kernel.ha.cluster.SwitchToSlave;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.cluster.member.HighAvailabilitySlaves;
import org.neo4j.kernel.ha.cluster.member.ObservedClusterMembers;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.DefaultSlaveFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.master.MasterImpl;
import org.neo4j.kernel.ha.com.master.MasterServer;
import org.neo4j.kernel.ha.com.master.SlaveFactory;
import org.neo4j.kernel.ha.com.master.Slaves;
import org.neo4j.kernel.ha.com.slave.InvalidEpochExceptionHandler;
import org.neo4j.kernel.ha.com.slave.MasterClientResolver;
import org.neo4j.kernel.ha.com.slave.SlaveServer;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.ha.lock.LockManagerModeSwitcher;
import org.neo4j.kernel.ha.management.ClusterDatabaseInfoProvider;
import org.neo4j.kernel.ha.management.HighlyAvailableKernelData;
import org.neo4j.kernel.ha.transaction.CommitPusher;
import org.neo4j.kernel.ha.transaction.OnDiskLastTxIdGetter;
import org.neo4j.kernel.ha.transaction.TransactionPropagator;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHeaderInformation;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.core.Caches;
import org.neo4j.kernel.impl.core.ReadOnlyTokenCreator;
import org.neo4j.kernel.impl.core.TokenCreator;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.storemigration.UpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedByDatabaseModeException;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.state.NeoStoreInjectedTransactionValidator;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.info.DiagnosticsProvider;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.LogbackWeakDependency;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;

public class HighlyAvailableGraphDatabase
extends InternalAbstractGraphDatabase {
    private final LifeSupport paxosLife = new LifeSupport();
    private final Dependencies dependencies = new Dependencies((Provider)new Provider<DependencyResolver>(){

        public DependencyResolver instance() {
            return HighlyAvailableGraphDatabase.this.dependencyResolver;
        }
    });
    private RequestContextFactory requestContextFactory;
    private ClusterMembers members;
    private DelegateInvocationHandler<Master> masterDelegateInvocationHandler;
    private Master master;
    private HighAvailabilityMemberStateMachine memberStateMachine;
    private LastUpdateTime lastUpdateTime;
    private HighAvailabilityMemberContext memberContext;
    private ClusterClient clusterClient;
    private ClusterMemberAvailability clusterMemberAvailability;
    private HighAvailabilityModeSwitcher highAvailabilityModeSwitcher;
    private long stateSwitchTimeoutMillis;
    private TransactionCommittingResponseUnpacker responseUnpacker;
    private Provider<KernelAPI> kernelProvider;
    private InvalidEpochExceptionHandler invalidEpochHandler;
    private InstanceId serverId;

    public HighlyAvailableGraphDatabase(String storeDir, Map<String, String> params, Iterable<KernelExtensionFactory<?>> kernelExtensions, Iterable<CacheProvider> cacheProviders, Monitors monitors) {
        this(storeDir, params, (InternalAbstractGraphDatabase.Dependencies)GraphDatabaseDependencies.newDependencies().settingsClasses(new Class[]{GraphDatabaseSettings.class, ClusterSettings.class, HaSettings.class}).kernelExtensions(kernelExtensions).cacheProviders(cacheProviders).monitors(monitors));
    }

    public HighlyAvailableGraphDatabase(String storeDir, Map<String, String> params, Iterable<KernelExtensionFactory<?>> kernelExtensions, Iterable<CacheProvider> cacheProviders) {
        this(storeDir, params, (InternalAbstractGraphDatabase.Dependencies)GraphDatabaseDependencies.newDependencies().settingsClasses(new Class[]{GraphDatabaseSettings.class, ClusterSettings.class, HaSettings.class}).kernelExtensions(kernelExtensions).cacheProviders(cacheProviders));
    }

    public HighlyAvailableGraphDatabase(String storeDir, Map<String, String> params, InternalAbstractGraphDatabase.Dependencies dependencies) {
        super(storeDir, params, dependencies);
        this.run();
    }

    protected void create() {
        this.life.add((Lifecycle)new BranchedDataMigrator(this.storeDir));
        this.masterDelegateInvocationHandler = new DelegateInvocationHandler<Master>(Master.class);
        this.master = (Master)Proxy.newProxyInstance(Master.class.getClassLoader(), new Class[]{Master.class}, this.masterDelegateInvocationHandler);
        this.serverId = (InstanceId)this.config.get(ClusterSettings.server_id);
        this.requestContextFactory = (RequestContextFactory)((Object)this.dependencies.satisfyDependency((Object)new RequestContextFactory(this.serverId.toIntegerIndex(), this.getDependencyResolver())));
        this.responseUnpacker = (TransactionCommittingResponseUnpacker)this.dependencies.satisfyDependency((Object)new TransactionCommittingResponseUnpacker(this.getDependencyResolver(), ((Integer)this.config.get(HaSettings.pull_apply_batch_size)).intValue()));
        this.kernelProvider = new Provider<KernelAPI>(){

            public KernelAPI instance() {
                return HighlyAvailableGraphDatabase.this.neoDataSource.getKernel();
            }
        };
        super.create();
        this.life.add((Lifecycle)this.requestContextFactory);
        this.life.add((Lifecycle)this.responseUnpacker);
        this.stateSwitchTimeoutMillis = (Long)this.config.get(HaSettings.state_switch_timeout);
        this.life.add((Lifecycle)this.paxosLife);
        this.life.add((Lifecycle)new DatabaseAvailability(this.availabilityGuard, this.transactionMonitor));
        this.life.add((Lifecycle)new StartupWaiter());
        this.diagnosticsManager.appendProvider((DiagnosticsProvider)new HighAvailabilityDiagnostics(this.memberStateMachine, this.clusterClient));
    }

    protected UpgradeConfiguration createUpgradeConfiguration() {
        return new HAUpgradeConfiguration();
    }

    protected void createDatabaseAvailability() {
    }

    public void start() {
        this.life.start();
    }

    public void stop() {
        this.life.stop();
    }

    public Transaction beginTx() {
        this.availabilityGuard.checkAvailability(this.stateSwitchTimeoutMillis, TransactionFailureException.class);
        return super.beginTx();
    }

    public IndexManager index() {
        this.availabilityGuard.checkAvailability(this.stateSwitchTimeoutMillis, TransactionFailureException.class);
        return super.index();
    }

    protected Logging createLogging() {
        Logging loggingService = (Logging)this.life.add((Lifecycle)LogbackWeakDependency.tryLoadLogbackService((Config)this.config, (Function)LogbackWeakDependency.NEW_LOGGER_CONTEXT, (Function)LogbackWeakDependency.DEFAULT_TO_CLASSIC, (Monitors)this.monitors));
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new NettyLoggerFactory(loggingService));
        return loggingService;
    }

    protected void createTxHook() {
        DelegateInvocationHandler<ClusterMemberEvents> clusterEventsDelegateInvocationHandler = new DelegateInvocationHandler<ClusterMemberEvents>(ClusterMemberEvents.class);
        DelegateInvocationHandler<HighAvailabilityMemberContext> memberContextDelegateInvocationHandler = new DelegateInvocationHandler<HighAvailabilityMemberContext>(HighAvailabilityMemberContext.class);
        DelegateInvocationHandler<ClusterMemberAvailability> clusterMemberAvailabilityDelegateInvocationHandler = new DelegateInvocationHandler<ClusterMemberAvailability>(ClusterMemberAvailability.class);
        Object clusterEventsProxy = Proxy.newProxyInstance(ClusterMemberEvents.class.getClassLoader(), new Class[]{ClusterMemberEvents.class, Lifecycle.class}, clusterEventsDelegateInvocationHandler);
        ClusterMemberEvents clusterEvents = (ClusterMemberEvents)this.dependencies.satisfyDependency((Object)((ClusterMemberEvents)clusterEventsProxy));
        this.paxosLife.add((Lifecycle)clusterEventsProxy);
        this.memberContext = (HighAvailabilityMemberContext)Proxy.newProxyInstance(HighAvailabilityMemberContext.class.getClassLoader(), new Class[]{HighAvailabilityMemberContext.class}, memberContextDelegateInvocationHandler);
        this.clusterMemberAvailability = (ClusterMemberAvailability)this.dependencies.satisfyDependency((Object)((ClusterMemberAvailability)Proxy.newProxyInstance(ClusterMemberAvailability.class.getClassLoader(), new Class[]{ClusterMemberAvailability.class}, clusterMemberAvailabilityDelegateInvocationHandler)));
        Object electionCredentialsProvider = (Boolean)this.config.get(HaSettings.slave_only) != false ? new NotElectableElectionCredentialsProvider() : new DefaultElectionCredentialsProvider((InstanceId)this.config.get(ClusterSettings.server_id), new OnDiskLastTxIdGetter((GraphDatabaseAPI)this), new HighAvailabilityMemberInfoProvider(){

            @Override
            public HighAvailabilityMemberState getHighAvailabilityMemberState() {
                return HighlyAvailableGraphDatabase.this.memberStateMachine.getCurrentState();
            }
        });
        ObjectStreamFactory objectStreamFactory = new ObjectStreamFactory();
        this.clusterClient = (ClusterClient)this.paxosLife.add((Lifecycle)this.dependencies.satisfyDependency((Object)new ClusterClient(this.monitors, ClusterClient.adapt((Config)this.config), this.logging, (ElectionCredentialsProvider)electionCredentialsProvider, (ObjectInputStreamFactory)objectStreamFactory, (ObjectOutputStreamFactory)objectStreamFactory)));
        PaxosClusterMemberEvents localClusterEvents = new PaxosClusterMemberEvents((Snapshot)this.clusterClient, (Cluster)this.clusterClient, (Heartbeat)this.clusterClient, (AtomicBroadcast)this.clusterClient, this.logging, (Predicate)new Predicate<PaxosClusterMemberEvents.ClusterMembersSnapshot>(){

            public boolean accept(PaxosClusterMemberEvents.ClusterMembersSnapshot item) {
                for (MemberIsAvailable member : item.getCurrentAvailableMembers()) {
                    if (!member.getRoleUri().getScheme().equals("ha") || !HighAvailabilityModeSwitcher.getServerId(member.getRoleUri()).equals(HighlyAvailableGraphDatabase.this.config.get(ClusterSettings.server_id))) continue;
                    HighlyAvailableGraphDatabase.this.msgLog.error(String.format("Instance %s has the same serverId as ours (%s) - will not join this cluster", member.getRoleUri(), ((InstanceId)HighlyAvailableGraphDatabase.this.config.get(ClusterSettings.server_id)).toIntegerIndex()));
                    return true;
                }
                return true;
            }
        }, (Function2)new HANewSnapshotFunction(), (ObjectInputStreamFactory)objectStreamFactory, (ObjectOutputStreamFactory)objectStreamFactory, (NamedThreadFactory.Monitor)this.monitors.newMonitor(NamedThreadFactory.Monitor.class, new String[0]));
        this.clusterClient.addClusterListener((ClusterListener)new ClusterListener.Adapter(){
            boolean hasRequestedElection = true;

            public void enteredCluster(ClusterConfiguration clusterConfiguration) {
                HighlyAvailableGraphDatabase.this.clusterClient.performRoleElections();
            }

            public void elected(String role, InstanceId instanceId, URI electedMember) {
                if (this.hasRequestedElection && role.equals("coordinator")) {
                    HighlyAvailableGraphDatabase.this.clusterClient.removeClusterListener((ClusterListener)this);
                }
            }
        });
        SimpleHighAvailabilityMemberContext localMemberContext = new SimpleHighAvailabilityMemberContext(this.clusterClient.getServerId(), (Boolean)this.config.get(HaSettings.slave_only));
        PaxosClusterMemberAvailability localClusterMemberAvailability = (PaxosClusterMemberAvailability)this.paxosLife.add((Lifecycle)new PaxosClusterMemberAvailability(this.clusterClient.getServerId(), (BindingNotifier)this.clusterClient, (AtomicBroadcast)this.clusterClient, this.logging, (ObjectInputStreamFactory)objectStreamFactory, (ObjectOutputStreamFactory)objectStreamFactory));
        memberContextDelegateInvocationHandler.setDelegate(localMemberContext);
        clusterEventsDelegateInvocationHandler.setDelegate((ClusterMemberEvents)localClusterEvents);
        clusterMemberAvailabilityDelegateInvocationHandler.setDelegate((ClusterMemberAvailability)localClusterMemberAvailability);
        ObservedClusterMembers observedMembers = new ObservedClusterMembers(this.logging, (Cluster)this.clusterClient, (Heartbeat)this.clusterClient, clusterEvents, (InstanceId)this.config.get(ClusterSettings.server_id));
        HighAvailabilityMemberStateMachine stateMachine = new HighAvailabilityMemberStateMachine(this.memberContext, this.availabilityGuard, observedMembers, clusterEvents, (Election)this.clusterClient, this.logging.getMessagesLog(HighAvailabilityMemberStateMachine.class));
        this.members = (ClusterMembers)this.dependencies.satisfyDependency((Object)new ClusterMembers(observedMembers, stateMachine));
        this.memberStateMachine = (HighAvailabilityMemberStateMachine)this.paxosLife.add((Lifecycle)stateMachine);
        HighAvailabilityConsoleLogger highAvailabilityConsoleLogger = new HighAvailabilityConsoleLogger(this.logging.getConsoleLog(HighAvailabilityConsoleLogger.class), (InstanceId)this.config.get(ClusterSettings.server_id));
        this.availabilityGuard.addListener((AvailabilityGuard.AvailabilityListener)highAvailabilityConsoleLogger);
        clusterEvents.addClusterMemberListener((ClusterMemberListener)highAvailabilityConsoleLogger);
        this.clusterClient.addClusterListener((ClusterListener)highAvailabilityConsoleLogger);
    }

    public void assertSchemaWritesAllowed() throws InvalidTransactionTypeKernelException {
        if (!this.isMaster()) {
            throw new InvalidTransactionTypeKernelException("Modifying the database schema can only be done on the master server, this server is a slave. Please issue schema modification commands directly to the master.");
        }
    }

    protected TransactionHeaderInformationFactory createHeaderInformationFactory() {
        return new TransactionHeaderInformationFactory.WithRandomBytes(){

            protected TransactionHeaderInformation createUsing(byte[] additionalHeader) {
                return new TransactionHeaderInformation(HighlyAvailableGraphDatabase.this.memberContext.getElectedMasterId().toIntegerIndex(), HighlyAvailableGraphDatabase.this.memberContext.getMyId().toIntegerIndex(), additionalHeader);
            }
        };
    }

    protected CommitProcessFactory getCommitProcessFactory() {
        final DelegateInvocationHandler<TransactionCommitProcess> commitProcessDelegate = new DelegateInvocationHandler<TransactionCommitProcess>(TransactionCommitProcess.class);
        DefaultSlaveFactory slaveFactory = (DefaultSlaveFactory)this.dependencies.satisfyDependency((Object)new DefaultSlaveFactory(this.logging, this.monitors, ((Long)this.config.get(HaSettings.com_chunk_size)).intValue()));
        HostnamePort me = (HostnamePort)this.config.get(ClusterSettings.cluster_server);
        Slaves slaves = (Slaves)this.dependencies.satisfyDependency((Object)this.life.add((Lifecycle)new HighAvailabilitySlaves(this.members, (Cluster)this.clusterClient, slaveFactory, me)));
        final TransactionPropagator pusher = (TransactionPropagator)this.life.add((Lifecycle)new TransactionPropagator(TransactionPropagator.from(this.config), this.msgLog, slaves, new CommitPusher(this.jobScheduler)));
        return new CommitProcessFactory(){

            public TransactionCommitProcess create(LogicalTransactionStore logicalTransactionStore, NeoStore neoStore, TransactionRepresentationStoreApplier storeApplier, NeoStoreInjectedTransactionValidator txValidator, IndexUpdatesValidator indexUpdatesValidator, Config config) {
                if (((Boolean)config.get(GraphDatabaseSettings.read_only)).booleanValue()) {
                    return InternalAbstractGraphDatabase.defaultCommitProcessFactory.create(logicalTransactionStore, neoStore, storeApplier, txValidator, indexUpdatesValidator, config);
                }
                TransactionCommitProcess inner = InternalAbstractGraphDatabase.defaultCommitProcessFactory.create(logicalTransactionStore, neoStore, storeApplier, txValidator, indexUpdatesValidator, config);
                HighlyAvailableGraphDatabase.this.paxosLife.add((Lifecycle)new CommitProcessSwitcher(pusher, HighlyAvailableGraphDatabase.this.master, commitProcessDelegate, HighlyAvailableGraphDatabase.this.requestContextFactory, HighlyAvailableGraphDatabase.this.highAvailabilityModeSwitcher, txValidator, inner));
                return (TransactionCommitProcess)Proxy.newProxyInstance(TransactionCommitProcess.class.getClassLoader(), new Class[]{TransactionCommitProcess.class}, (InvocationHandler)commitProcessDelegate);
            }
        };
    }

    protected IdGeneratorFactory createIdGeneratorFactory() {
        this.idGeneratorFactory = new HaIdGeneratorFactory(this.masterDelegateInvocationHandler, this.logging, this.requestContextFactory);
        ((HaIdGeneratorFactory)this.idGeneratorFactory).switchToMaster();
        return this.idGeneratorFactory;
    }

    protected void createModeSwitcher() {
        ConsoleLogger consoleLog = this.logging.getConsoleLog(HighAvailabilityModeSwitcher.class);
        this.invalidEpochHandler = new InvalidEpochExceptionHandler(){

            @Override
            public void handle() {
                HighlyAvailableGraphDatabase.this.highAvailabilityModeSwitcher.forceElections();
            }
        };
        DelegateInvocationHandler<UpdatePuller> updatePullerDelegate = new DelegateInvocationHandler<UpdatePuller>(UpdatePuller.class);
        UpdatePuller updatePullerProxy = (UpdatePuller)Proxy.newProxyInstance(UpdatePuller.class.getClassLoader(), new Class[]{UpdatePuller.class}, updatePullerDelegate);
        this.dependencies.satisfyDependency((Object)updatePullerProxy);
        this.lastUpdateTime = new LastUpdateTime();
        PullerFactory pullerFactory = new PullerFactory(this.requestContextFactory, this.master, this.lastUpdateTime, this.logging, this.serverId, this.invalidEpochHandler, (Long)this.config.get(HaSettings.pull_interval), this.jobScheduler, (DependencyResolver)this.dependencies, this.availabilityGuard, this.memberStateMachine);
        TransactionObligationFulfiller obligationFulfiller = (TransactionObligationFulfiller)this.dependencies.satisfyDependency((Object)pullerFactory.createObligationFulfiller(this.paxosLife, updatePullerProxy));
        MasterClientResolver masterClientResolver = new MasterClientResolver(this.logging, (ResponseUnpacker)this.responseUnpacker, this.invalidEpochHandler, ((Long)this.config.get(HaSettings.read_timeout)).intValue(), ((Long)this.config.get(HaSettings.lock_read_timeout)).intValue(), (Integer)this.config.get(HaSettings.max_concurrent_channels_per_slave), ((Long)this.config.get(HaSettings.com_chunk_size)).intValue());
        SwitchToSlave switchToSlaveInstance = new SwitchToSlave(consoleLog, this.config, this.getDependencyResolver(), (HaIdGeneratorFactory)this.idGeneratorFactory, this.logging, this.masterDelegateInvocationHandler, this.clusterMemberAvailability, this.requestContextFactory, this.kernelExtensions.listFactories(), masterClientResolver, updatePullerProxy, pullerFactory, (ByteCounterMonitor)this.monitors.newMonitor(ByteCounterMonitor.class, SlaveServer.class, new String[0]), (RequestMonitor)this.monitors.newMonitor(RequestMonitor.class, SlaveServer.class, new String[0]), (SwitchToSlave.Monitor)this.monitors.newMonitor(SwitchToSlave.Monitor.class, new String[0]), (StoreCopyClient.Monitor)this.monitors.newMonitor(StoreCopyClient.Monitor.class, new String[0]));
        SwitchToMaster switchToMasterInstance = new SwitchToMaster(this.logging, consoleLog, (GraphDatabaseAPI)this, (HaIdGeneratorFactory)this.idGeneratorFactory, this.config, (Provider<SlaveFactory>)this.dependencies.provideDependency(SlaveFactory.class), this.masterDelegateInvocationHandler, this.clusterMemberAvailability, this.dataSourceManager, (ByteCounterMonitor)this.monitors.newMonitor(ByteCounterMonitor.class, MasterServer.class, new String[0]), (RequestMonitor)this.monitors.newMonitor(RequestMonitor.class, MasterServer.class, new String[0]), (MasterImpl.Monitor)this.monitors.newMonitor(MasterImpl.Monitor.class, MasterImpl.class, new String[0]));
        this.highAvailabilityModeSwitcher = new HighAvailabilityModeSwitcher(switchToSlaveInstance, switchToMasterInstance, (Election)this.clusterClient, this.clusterMemberAvailability, this.getDependencyResolver(), (InstanceId)this.config.get(ClusterSettings.server_id), this.logging, this.dataSourceManager);
        this.paxosLife.add((Lifecycle)new UpdatePullerModeSwitcher(this.highAvailabilityModeSwitcher, updatePullerDelegate, pullerFactory));
        this.clusterClient.addBindingListener((BindingListener)this.highAvailabilityModeSwitcher);
        this.memberStateMachine.addHighAvailabilityMemberListener(this.highAvailabilityModeSwitcher);
        this.paxosLife.add((Lifecycle)this.highAvailabilityModeSwitcher);
    }

    protected Locks createLockManager() {
        DelegateInvocationHandler<Locks> lockManagerDelegate = new DelegateInvocationHandler<Locks>(Locks.class);
        Locks lockManager = (Locks)Proxy.newProxyInstance(Locks.class.getClassLoader(), new Class[]{Locks.class}, lockManagerDelegate);
        this.paxosLife.add((Lifecycle)new LockManagerModeSwitcher(this.highAvailabilityModeSwitcher, lockManagerDelegate, this.masterDelegateInvocationHandler, this.requestContextFactory, this.availabilityGuard, this.config, new Factory<Locks>(){

            public Locks newInstance() {
                return HighlyAvailableGraphDatabase.super.createLockManager();
            }
        }));
        return lockManager;
    }

    protected TokenCreator createRelationshipTypeCreator() {
        if (((Boolean)this.config.get(GraphDatabaseSettings.read_only)).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        DelegateInvocationHandler<TokenCreator> relationshipTypeCreatorDelegate = new DelegateInvocationHandler<TokenCreator>(TokenCreator.class);
        TokenCreator relationshipTypeCreator = (TokenCreator)Proxy.newProxyInstance(TokenCreator.class.getClassLoader(), new Class[]{TokenCreator.class}, relationshipTypeCreatorDelegate);
        this.paxosLife.add((Lifecycle)new RelationshipTypeCreatorModeSwitcher(this.highAvailabilityModeSwitcher, relationshipTypeCreatorDelegate, this.masterDelegateInvocationHandler, this.requestContextFactory, this.kernelProvider, this.idGeneratorFactory));
        return relationshipTypeCreator;
    }

    protected TokenCreator createPropertyKeyCreator() {
        if (((Boolean)this.config.get(GraphDatabaseSettings.read_only)).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        DelegateInvocationHandler<TokenCreator> propertyKeyCreatorDelegate = new DelegateInvocationHandler<TokenCreator>(TokenCreator.class);
        TokenCreator propertyTokenCreator = (TokenCreator)Proxy.newProxyInstance(TokenCreator.class.getClassLoader(), new Class[]{TokenCreator.class}, propertyKeyCreatorDelegate);
        this.paxosLife.add((Lifecycle)new PropertyKeyCreatorModeSwitcher(this.highAvailabilityModeSwitcher, propertyKeyCreatorDelegate, this.masterDelegateInvocationHandler, this.requestContextFactory, this.kernelProvider, this.idGeneratorFactory));
        return propertyTokenCreator;
    }

    protected TokenCreator createLabelIdCreator() {
        if (((Boolean)this.config.get(GraphDatabaseSettings.read_only)).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        DelegateInvocationHandler<TokenCreator> labelIdCreatorDelegate = new DelegateInvocationHandler<TokenCreator>(TokenCreator.class);
        TokenCreator labelIdCreator = (TokenCreator)Proxy.newProxyInstance(TokenCreator.class.getClassLoader(), new Class[]{TokenCreator.class}, labelIdCreatorDelegate);
        this.paxosLife.add((Lifecycle)new LabelTokenCreatorModeSwitcher(this.highAvailabilityModeSwitcher, labelIdCreatorDelegate, this.masterDelegateInvocationHandler, this.requestContextFactory, this.kernelProvider, this.idGeneratorFactory));
        return labelIdCreator;
    }

    protected Caches createCaches() {
        return new HaCaches(this.logging.getMessagesLog(Caches.class), this.monitors);
    }

    protected KernelData createKernelData(LifeSupport life) {
        OnDiskLastTxIdGetter txIdGetter = new OnDiskLastTxIdGetter((GraphDatabaseAPI)this);
        ClusterDatabaseInfoProvider databaseInfo = new ClusterDatabaseInfoProvider(this.members, txIdGetter, this.lastUpdateTime);
        return (KernelData)life.add((Lifecycle)new HighlyAvailableKernelData(this, this.members, databaseInfo));
    }

    protected void registerRecovery() {
        this.memberStateMachine.addHighAvailabilityMemberListener(new HighAvailabilityMemberListener(){

            @Override
            public void masterIsElected(HighAvailabilityMemberChangeEvent event) {
            }

            @Override
            public void masterIsAvailable(HighAvailabilityMemberChangeEvent event) {
                if (event.getOldState().equals((Object)HighAvailabilityMemberState.TO_MASTER) && event.getNewState().equals((Object)HighAvailabilityMemberState.MASTER)) {
                    this.doAfterRecoveryAndStartup(true);
                }
            }

            @Override
            public void slaveIsAvailable(HighAvailabilityMemberChangeEvent event) {
                if (event.getOldState().equals((Object)HighAvailabilityMemberState.TO_SLAVE) && event.getNewState().equals((Object)HighAvailabilityMemberState.SLAVE)) {
                    this.doAfterRecoveryAndStartup(false);
                }
            }

            @Override
            public void instanceStops(HighAvailabilityMemberChangeEvent event) {
            }

            private void doAfterRecoveryAndStartup(boolean isMaster) {
                try {
                    HighlyAvailableGraphDatabase.this.doAfterRecoveryAndStartup(isMaster);
                }
                catch (Throwable throwable) {
                    HighlyAvailableGraphDatabase.this.msgLog.error("Post recovery error", throwable);
                    try {
                        HighlyAvailableGraphDatabase.this.memberStateMachine.stop();
                    }
                    catch (Throwable throwable1) {
                        HighlyAvailableGraphDatabase.this.msgLog.warn("Could not stop", throwable1);
                    }
                    try {
                        HighlyAvailableGraphDatabase.this.memberStateMachine.start();
                    }
                    catch (Throwable throwable1) {
                        HighlyAvailableGraphDatabase.this.msgLog.warn("Could not start", throwable1);
                    }
                }
            }
        });
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.storeDir + "]";
    }

    public HighAvailabilityMemberState getInstanceState() {
        return this.memberStateMachine.getCurrentState();
    }

    public String role() {
        return this.members.getCurrentMemberRole();
    }

    public boolean isMaster() {
        return "master".equals(this.role());
    }

    public DependencyResolver getDependencyResolver() {
        return this.dependencies;
    }

    private class StartupWaiter
    extends LifecycleAdapter {
        private StartupWaiter() {
        }

        public void start() throws Throwable {
            HighlyAvailableGraphDatabase.this.availabilityGuard.isAvailable(HighlyAvailableGraphDatabase.this.stateSwitchTimeoutMillis);
        }
    }

    private static final class HAUpgradeConfiguration
    implements UpgradeConfiguration {
        private HAUpgradeConfiguration() {
        }

        public void checkConfigurationAllowsAutomaticUpgrade() {
            throw new UpgradeNotAllowedByDatabaseModeException();
        }
    }
}

