/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import java.util.Arrays;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.locking.DumpLocksVisitor;
import org.neo4j.kernel.impl.locking.LockType;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.util.StringBuilderStringLogger;
import org.neo4j.kernel.impl.util.StringLogger;

public class LocalDeadlockDetectedException
extends DeadlockDetectedException {
    public LocalDeadlockDetectedException(Locks.Client lockClient, Locks lockManager, Locks.ResourceType resourceType, long[] resourceIds, LockType type) {
        super(LocalDeadlockDetectedException.constructHelpfulDiagnosticsMessage(lockClient, lockManager, resourceType, resourceIds, type));
    }

    private static String constructHelpfulDiagnosticsMessage(Locks.Client client, Locks lockManager, Locks.ResourceType resourceType, long[] resourceIds, LockType type) {
        StringBuilder builder = new StringBuilder(String.format("%s tried to apply local %s lock on %s(%s) after acquired on master. Currently these locks exist:%n", client, type, resourceType, Arrays.toString(resourceIds)));
        lockManager.accept((Locks.Visitor)new DumpLocksVisitor((StringLogger)new StringBuilderStringLogger(builder)));
        return builder.toString();
    }
}

