/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.management;

import java.util.ArrayList;
import org.neo4j.function.Function;
import org.neo4j.helpers.Functions;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.Version;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.management.ClusterDatabaseInfoProvider;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.management.ClusterDatabaseInfo;
import org.neo4j.management.ClusterMemberInfo;

public class HighlyAvailableKernelData
extends KernelData
implements Lifecycle {
    private final HighlyAvailableGraphDatabase db;
    private final ClusterMembers memberInfo;
    private final ClusterDatabaseInfoProvider memberInfoProvider;

    public HighlyAvailableKernelData(HighlyAvailableGraphDatabase db, ClusterMembers memberInfo, ClusterDatabaseInfoProvider databaseInfo) {
        super(db.getConfig());
        this.db = db;
        this.memberInfo = memberInfo;
        this.memberInfoProvider = databaseInfo;
    }

    public void init() throws Throwable {
    }

    public void start() throws Throwable {
    }

    public void stop() throws Throwable {
    }

    public void shutdown() {
        super.shutdown();
    }

    public Version version() {
        return Version.getKernel();
    }

    public GraphDatabaseAPI graphDatabase() {
        return this.db;
    }

    public ClusterMemberInfo[] getClusterInfo() {
        ArrayList<ClusterMemberInfo> clusterMemberInfos = new ArrayList<ClusterMemberInfo>();
        for (ClusterMember clusterMember : this.memberInfo.getMembers()) {
            ClusterMemberInfo clusterMemberInfo = new ClusterMemberInfo(clusterMember.getInstanceId().toString(), clusterMember.getHAUri() != null, clusterMember.isAlive(), clusterMember.getHARole(), (String[])Iterables.toArray(String.class, (Iterable)Iterables.map((Function)Functions.TO_STRING, clusterMember.getRoleURIs())), (String[])Iterables.toArray(String.class, (Iterable)Iterables.map((Function)Functions.TO_STRING, clusterMember.getRoles())));
            clusterMemberInfos.add(clusterMemberInfo);
        }
        return clusterMemberInfos.toArray(new ClusterMemberInfo[clusterMemberInfos.size()]);
    }

    public ClusterDatabaseInfo getMemberInfo() {
        return this.memberInfoProvider.getInfo();
    }
}

