/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.InvalidTransactionTypeException;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

public class ConstraintsInHAIT {
    @Rule
    public ClusterRule clusterRule = new ClusterRule(this.getClass());

    @Test
    public void creatingConstraintOnSlaveIsNotAllowed() throws Exception {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        slave.beginTx();
        try {
            ConstraintCreator constraintCreator = slave.schema().constraintFor(DynamicLabel.label((String)"LabelName")).assertPropertyIsUnique("PropertyName");
            constraintCreator.create();
            Assert.fail((String)"should have thrown exception");
        }
        catch (InvalidTransactionTypeException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"Modifying the database schema can only be done on the master server, this server is a slave. Please issue schema modification commands directly to the master."));
        }
    }
}

