/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePullerClient;
import org.neo4j.test.LoggerRule;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

@Ignore(value="Fails too often")
public class MultipleClusterTest {
    @Rule
    public LoggerRule logging = new LoggerRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void runTwoClusters() throws Throwable {
        File root = TargetDirectory.forTest(this.getClass()).cleanDirectory("cluster");
        ClusterManager clusterManager = new ClusterManager(ClusterManager.fromXml(this.getClass().getResource("/twoclustertest.xml").toURI()), root, MapUtil.stringMap((String[])new String[0]));
        try {
            Transaction transaction;
            clusterManager.start();
            ClusterManager.ManagedCluster cluster1 = clusterManager.getCluster("neo4j.ha");
            HighlyAvailableGraphDatabase master = cluster1.getMaster();
            this.logging.getLogger().info("CREATE NODE");
            Transaction tx = master.beginTx();
            Node node = master.createNode();
            node.setProperty("cluster", (Object)"neo4j.ha");
            long cluster1NodeId = node.getId();
            this.logging.getLogger().info("CREATED NODE");
            tx.success();
            tx.finish();
            ClusterManager.ManagedCluster cluster2 = clusterManager.getCluster("neo4j.ha2");
            HighlyAvailableGraphDatabase master2 = cluster2.getMaster();
            this.logging.getLogger().info("CREATE NODE");
            Transaction tx2 = master2.beginTx();
            Node node2 = master2.createNode();
            node2.setProperty("cluster", (Object)"neo4j.ha2");
            long cluster2NodeId = node2.getId();
            this.logging.getLogger().info("CREATED NODE");
            tx2.success();
            tx2.finish();
            for (HighlyAvailableGraphDatabase highlyAvailableGraphDatabase : cluster1.getAllMembers()) {
                ((UpdatePullerClient)highlyAvailableGraphDatabase.getDependencyResolver().resolveDependency(UpdatePullerClient.class)).pullUpdates();
                transaction = highlyAvailableGraphDatabase.beginTx();
                Assert.assertEquals((Object)"neo4j.ha", (Object)highlyAvailableGraphDatabase.getNodeById(cluster1NodeId).getProperty("cluster"));
                transaction.finish();
            }
            for (HighlyAvailableGraphDatabase highlyAvailableGraphDatabase : cluster2.getAllMembers()) {
                ((UpdatePullerClient)highlyAvailableGraphDatabase.getDependencyResolver().resolveDependency(UpdatePullerClient.class)).pullUpdates();
                transaction = highlyAvailableGraphDatabase.beginTx();
                Assert.assertEquals((Object)"neo4j.ha2", (Object)highlyAvailableGraphDatabase.getNodeById(cluster2NodeId).getProperty("cluster"));
                transaction.finish();
            }
        }
        finally {
            clusterManager.stop();
        }
    }
}

