/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha.upgrade;

import java.io.File;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.ha.upgrade.LegacyDatabase;
import org.neo4j.ha.upgrade.RollingUpgradeIT;
import org.neo4j.ha.upgrade.Utils;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePullerClient;
import org.neo4j.shell.impl.RmiLocation;
import org.neo4j.test.ProcessStreamHandler;

public class LegacyDatabaseImpl
extends UnicastRemoteObject
implements LegacyDatabase {
    private final GraphDatabaseAPI db;
    private final String storeDir;

    public static void main(String[] args) throws Exception {
        Args arguments = Args.parse((String[])args);
        String storeDir = (String)arguments.orphans().get(0);
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestHighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(storeDir).setConfig(arguments.asMap()).newGraphDatabase();
        LegacyDatabaseImpl legacyDb = new LegacyDatabaseImpl(storeDir, db);
        LegacyDatabaseImpl.rmiLocation(Integer.parseInt((String)arguments.orphans().get(1))).bind((Remote)legacyDb);
    }

    public LegacyDatabaseImpl(String storeDir, GraphDatabaseAPI db) throws RemoteException {
        this.storeDir = storeDir;
        this.db = db;
    }

    public static Future<LegacyDatabase> start(String classpath, File storeDir, Map<String, String> config) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        args.add(storeDir.getAbsolutePath());
        int rmiPort = 7000 + Integer.parseInt(config.get("ha.server_id"));
        args.add("" + rmiPort);
        args.addAll(Arrays.asList(new Args(config).asArgs()));
        final Process process = Utils.execJava(LegacyDatabaseImpl.appendNecessaryTestClasses(classpath), LegacyDatabaseImpl.class.getName(), args.toArray(new String[0]));
        new ProcessStreamHandler(process, false).launch();
        final RmiLocation rmiLocation = LegacyDatabaseImpl.rmiLocation(rmiPort);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<LegacyDatabase> future = executor.submit(new Callable<LegacyDatabase>(){

            @Override
            public LegacyDatabase call() throws Exception {
                long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10000L);
                while (System.currentTimeMillis() < endTime) {
                    try {
                        return (LegacyDatabase)rmiLocation.getBoundObject();
                    }
                    catch (RemoteException e) {
                        Thread.sleep(100L);
                    }
                }
                process.destroy();
                throw new IllegalStateException("Couldn't get remote to legacy database");
            }
        });
        executor.shutdown();
        return future;
    }

    private static String appendNecessaryTestClasses(String classpath) {
        for (String path : System.getProperty("java.class.path").split(File.pathSeparator)) {
            if (!path.contains("test-classes") || path.contains(File.separator + "kernel" + File.separator)) continue;
            classpath = classpath + File.pathSeparator + path;
        }
        return classpath;
    }

    private static RmiLocation rmiLocation(int rmiPort) {
        return RmiLocation.location((String)"127.0.0.1", (int)rmiPort, (String)"remote");
    }

    @Override
    public int stop() {
        this.db.shutdown();
        System.exit(0);
        return 0;
    }

    @Override
    public String getStoreDir() {
        return this.storeDir;
    }

    @Override
    public void awaitStarted(long time, TimeUnit unit) {
        this.db.beginTx().finish();
    }

    @Override
    public long createNode() throws RemoteException {
        long result = -1L;
        try (Transaction tx = this.db.beginTx();){
            result = this.db.createNode().getId();
            tx.success();
        }
        return result;
    }

    @Override
    public long initialize() {
        long result = -1L;
        try (Transaction tx = this.db.beginTx();){
            long current;
            int i;
            Node center = this.db.createNode();
            result = center.getId();
            long largest = 0L;
            for (i = 0; i < 100; ++i) {
                current = center.createRelationshipTo(this.db.createNode(), RollingUpgradeIT.type1).getId();
                if (current <= largest) continue;
                largest = current;
            }
            for (i = 0; i < 100; ++i) {
                current = center.createRelationshipTo(this.db.createNode(), RollingUpgradeIT.type2).getId();
                if (current <= largest) continue;
                largest = current;
            }
            for (Relationship rel : center.getRelationships()) {
                rel.setProperty("relProp", (Object)("relProp" + rel.getId() + "-" + largest));
                Node other = rel.getEndNode();
                other.setProperty("nodeProp", (Object)("nodeProp" + other.getId() + "-" + largest));
            }
            tx.success();
        }
        return result;
    }

    @Override
    public void doComplexLoad(long center) {
        try (Transaction tx = this.db.beginTx();){
            int i;
            Node central = this.db.getNodeById(center);
            long[] type1RelId = new long[100];
            long[] type2RelId = new long[100];
            int index = 0;
            for (Relationship relationship : central.getRelationships(new RelationshipType[]{RollingUpgradeIT.type1})) {
                type1RelId[index++] = relationship.getId();
            }
            index = 0;
            for (Relationship relationship : central.getRelationships(new RelationshipType[]{RollingUpgradeIT.type2})) {
                type2RelId[index++] = relationship.getId();
            }
            Arrays.sort(type1RelId);
            Arrays.sort(type2RelId);
            for (i = 0; i < type1RelId.length / 2; ++i) {
                this.db.getRelationshipById(type1RelId[i]).delete();
            }
            for (i = 0; i < type2RelId.length / 2; ++i) {
                this.db.getRelationshipById(type2RelId[i]).delete();
            }
            for (i = 0; i < type1RelId.length / 2; ++i) {
                central.createRelationshipTo(this.db.createNode(), RollingUpgradeIT.type1);
            }
            long largestCreated = 0L;
            for (int i2 = 0; i2 < type2RelId.length / 2; ++i2) {
                long current = central.createRelationshipTo(this.db.createNode(), RollingUpgradeIT.type2).getId();
                if (current <= largestCreated) continue;
                largestCreated = current;
            }
            for (Relationship relationship : central.getRelationships()) {
                relationship.setProperty("relProp", (Object)("relProp" + relationship.getId() + "-" + largestCreated));
                Node end = relationship.getEndNode();
                end.setProperty("nodeProp", (Object)("nodeProp" + end.getId() + "-" + largestCreated));
            }
            tx.success();
        }
    }

    @Override
    public void verifyComplexLoad(long centralNode) {
        try (Transaction tx = this.db.beginTx();){
            Node other;
            Node center = this.db.getNodeById(centralNode);
            long maxRelId = -1L;
            for (Relationship relationship : center.getRelationships()) {
                if (relationship.getId() <= maxRelId) continue;
                maxRelId = relationship.getId();
            }
            int typeCount = 0;
            for (Relationship relationship : center.getRelationships(new RelationshipType[]{RollingUpgradeIT.type1})) {
                ++typeCount;
                if (!relationship.getProperty("relProp").equals("relProp" + relationship.getId() + "-" + maxRelId)) {
                    Assert.fail((String)"damn");
                }
                if ((other = relationship.getEndNode()).getProperty("nodeProp").equals("nodeProp" + other.getId() + "-" + maxRelId)) continue;
                Assert.fail((String)"double damn");
            }
            if (typeCount != 100) {
                Assert.fail((String)"tripled damn");
            }
            typeCount = 0;
            for (Relationship relationship : center.getRelationships(new RelationshipType[]{RollingUpgradeIT.type2})) {
                ++typeCount;
                if (!relationship.getProperty("relProp").equals("relProp" + relationship.getId() + "-" + maxRelId)) {
                    Assert.fail((String)"damn2");
                }
                if ((other = relationship.getEndNode()).getProperty("nodeProp").equals("nodeProp" + other.getId() + "-" + maxRelId)) continue;
                Assert.fail((String)"double damn2");
            }
            if (typeCount != 100) {
                Assert.fail((String)"tripled damn2");
            }
            tx.success();
        }
    }

    @Override
    public void verifyNodeExists(long id) {
        try {
            ((UpdatePullerClient)this.db.getDependencyResolver().resolveDependency(UpdatePullerClient.class)).pullUpdates();
        }
        catch (Exception e) {
            throw Exceptions.launderedException((Throwable)e);
        }
        try (Transaction tx = this.db.beginTx();){
            this.db.getNodeById(id);
            tx.success();
        }
    }

    @Override
    public boolean isMaster() throws RemoteException {
        return ((HighlyAvailableGraphDatabase)this.db).isMaster();
    }
}

