/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.junit.After;
import org.junit.Assert;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public class DeletionTest {
    private ClusterManager clusterManager;

    @After
    public void after() throws Throwable {
        if (this.clusterManager != null) {
            this.clusterManager.stop();
            this.clusterManager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shouldDeleteRecords() throws Throwable {
        Relationship rel;
        this.clusterManager = new ClusterManager(ClusterManager.clusterOfSize(2), TargetDirectory.forTest(this.getClass()).cleanDirectory("deleteRecords"), MapUtil.stringMap((String[])new String[0]));
        this.clusterManager.start();
        ClusterManager.ManagedCluster cluster = this.clusterManager.getDefaultCluster();
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        Transaction tx = slave.beginTx();
        try {
            rel = slave.createNode().createRelationshipTo(slave.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"FOO"));
            tx.success();
        }
        finally {
            tx.finish();
        }
        Transaction transaction = master.beginTx();
        try {
            Assert.assertNotNull((Object)master.getRelationshipById(rel.getId()));
        }
        finally {
            transaction.finish();
        }
        tx = slave.beginTx();
        try {
            rel.delete();
            tx.success();
        }
        finally {
            tx.finish();
        }
        slave.shutdown();
        master.shutdown();
    }
}

