/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.ha.transaction.OnDiskLastTxIdGetter;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.transaction.state.NeoStoreProvider;

public class OnDiskLastTxIdGetterTest {
    @Test
    public void testGetLastTxIdNoFilePresent() throws Exception {
        InternalAbstractGraphDatabase graphdb = (InternalAbstractGraphDatabase)Mockito.mock(InternalAbstractGraphDatabase.class);
        DependencyResolver resolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        NeoStoreProvider provider = (NeoStoreProvider)Mockito.mock(NeoStoreProvider.class);
        NeoStore neoStore = (NeoStore)Mockito.mock(NeoStore.class);
        Mockito.when((Object)graphdb.getDependencyResolver()).thenReturn((Object)resolver);
        Mockito.when((Object)resolver.resolveDependency(NeoStoreProvider.class)).thenReturn((Object)provider);
        Mockito.when((Object)provider.evaluate()).thenReturn((Object)neoStore);
        Mockito.when((Object)neoStore.getLastCommittedTransactionId()).thenReturn((Object)13L);
        OnDiskLastTxIdGetter getter = new OnDiskLastTxIdGetter((GraphDatabaseAPI)graphdb);
        Assert.assertEquals((long)13L, (long)getter.getLastTxId());
    }
}

