/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.neo4j.cluster.InstanceId;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public class TxPushStrategyConfigIT {
    private final LifeSupport life = new LifeSupport();
    private ClusterManager.ManagedCluster cluster;
    private TargetDirectory dir;
    @Rule
    public TestName name = new TestName();
    private static int MASTER = 1;
    private static int FIRST_SLAVE = 2;
    private static int SECOND_SLAVE = 3;
    private static int THIRD_SLAVE = 4;
    private static int FOURTH_SLAVE = 5;
    private InstanceId[] machineIds;

    @Test
    public void shouldPushToSlavesInDescendingOrder() throws Exception {
        this.startCluster(4, 2, "fixed");
        for (int i = 0; i < 5; ++i) {
            this.createTransactionOnMaster();
            this.assertLastTransactions(this.lastTx(THIRD_SLAVE, 2L + (long)i));
            this.assertLastTransactions(this.lastTx(SECOND_SLAVE, 2L + (long)i));
            this.assertLastTransactions(this.lastTx(FIRST_SLAVE, 1L));
        }
    }

    @Test
    public void twoRoundRobin() throws Exception {
        this.startCluster(5, 2, "round_robin");
        this.createTransactionOnMaster();
        this.assertLastTransactions(this.lastTx(FIRST_SLAVE, 2L), this.lastTx(SECOND_SLAVE, 2L), this.lastTx(THIRD_SLAVE, 1L), this.lastTx(FOURTH_SLAVE, 1L));
        this.createTransactionOnMaster();
        this.assertLastTransactions(this.lastTx(FIRST_SLAVE, 2L), this.lastTx(SECOND_SLAVE, 3L), this.lastTx(THIRD_SLAVE, 3L), this.lastTx(FOURTH_SLAVE, 1L));
        this.createTransactionOnMaster();
        this.assertLastTransactions(this.lastTx(FIRST_SLAVE, 2L), this.lastTx(SECOND_SLAVE, 3L), this.lastTx(THIRD_SLAVE, 4L), this.lastTx(FOURTH_SLAVE, 4L));
        this.createTransactionOnMaster();
        this.assertLastTransactions(this.lastTx(FIRST_SLAVE, 5L), this.lastTx(SECOND_SLAVE, 3L), this.lastTx(THIRD_SLAVE, 4L), this.lastTx(FOURTH_SLAVE, 5L));
    }

    @Test
    public void shouldPushToOneLessSlaveOnSlaveCommit() throws Exception {
        this.startCluster(4, 2, "fixed");
        this.createTransactionOn(new InstanceId(FIRST_SLAVE));
        this.assertLastTransactions(this.lastTx(MASTER, 2L), this.lastTx(FIRST_SLAVE, 2L), this.lastTx(SECOND_SLAVE, 1L), this.lastTx(THIRD_SLAVE, 2L));
        this.createTransactionOn(new InstanceId(SECOND_SLAVE));
        this.assertLastTransactions(this.lastTx(MASTER, 3L), this.lastTx(FIRST_SLAVE, 2L), this.lastTx(SECOND_SLAVE, 3L), this.lastTx(THIRD_SLAVE, 3L));
        this.createTransactionOn(new InstanceId(THIRD_SLAVE));
        this.assertLastTransactions(this.lastTx(MASTER, 4L), this.lastTx(FIRST_SLAVE, 2L), this.lastTx(SECOND_SLAVE, 4L), this.lastTx(THIRD_SLAVE, 4L));
    }

    @Test
    public void slavesListGetsUpdatedWhenSlaveLeavesNicely() throws Exception {
        this.startCluster(3, 1, "fixed");
        this.cluster.shutdown(this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]));
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
    }

    @Test
    public void slaveListIsCorrectAfterMasterSwitch() throws Exception {
        this.startCluster(3, 1, "fixed");
        this.cluster.shutdown(this.cluster.getMaster());
        this.cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        HighlyAvailableGraphDatabase newMaster = this.cluster.getMaster();
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
        this.createTransaction((GraphDatabaseAPI)newMaster);
        this.assertLastTransactions(this.lastTx(FIRST_SLAVE, 2L), this.lastTx(SECOND_SLAVE, 2L));
    }

    @Test
    public void slavesListGetsUpdatedWhenSlaveRageQuits() throws Throwable {
        this.startCluster(3, 1, "fixed");
        this.cluster.fail(this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]));
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
    }

    @Before
    public void before() throws Exception {
        this.dir = TargetDirectory.forTest(this.getClass());
    }

    @After
    public void after() throws Exception {
        this.life.shutdown();
    }

    private void startCluster(int memberCount, final int pushFactor, final String pushStrategy) {
        ClusterManager clusterManager = (ClusterManager)((Object)this.life.add((Object)new ClusterManager(ClusterManager.clusterOfSize(memberCount), this.dir.cleanDirectory(this.name.getMethodName()), MapUtil.stringMap((String[])new String[0])){

            @Override
            protected void config(GraphDatabaseBuilder builder, String clusterName, InstanceId serverId) {
                builder.setConfig(HaSettings.tx_push_factor, "" + pushFactor);
                builder.setConfig(HaSettings.tx_push_strategy, pushStrategy);
            }
        }));
        this.life.start();
        this.cluster = clusterManager.getDefaultCluster();
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        this.mapMachineIds();
    }

    private void mapMachineIds() {
        this.machineIds = new InstanceId[this.cluster.size()];
        this.machineIds[0] = this.cluster.getServerId(this.cluster.getMaster());
        ArrayList<HighlyAvailableGraphDatabase> slaves = new ArrayList<HighlyAvailableGraphDatabase>();
        for (HighlyAvailableGraphDatabase hadb : this.cluster.getAllMembers()) {
            if (hadb.isMaster()) continue;
            slaves.add(hadb);
        }
        Collections.sort(slaves, new Comparator<HighlyAvailableGraphDatabase>(){

            @Override
            public int compare(HighlyAvailableGraphDatabase o1, HighlyAvailableGraphDatabase o2) {
                return TxPushStrategyConfigIT.this.cluster.getServerId(o1).compareTo(TxPushStrategyConfigIT.this.cluster.getServerId(o2));
            }
        });
        Iterator iter = slaves.iterator();
        int i = 1;
        while (iter.hasNext()) {
            this.machineIds[i] = this.cluster.getServerId((HighlyAvailableGraphDatabase)iter.next());
            ++i;
        }
    }

    private void assertLastTransactions(LastTxMapping ... transactionMappings) {
        StringBuilder failures = new StringBuilder();
        for (LastTxMapping mapping : transactionMappings) {
            HighlyAvailableGraphDatabase db = this.cluster.getMemberByServerId(mapping.serverId);
            mapping.format(failures, this.getLastTx((GraphDatabaseAPI)db));
        }
        Assert.assertTrue((String)failures.toString(), (failures.length() == 0 ? 1 : 0) != 0);
    }

    private long getLastTx(GraphDatabaseAPI db) {
        return ((TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastCommittedTransactionId();
    }

    private LastTxMapping lastTx(int serverIndex, long txId) {
        InstanceId serverId = this.machineIds[serverIndex - 1];
        return new LastTxMapping(serverId, txId);
    }

    private void createTransactionOnMaster() {
        this.createTransaction((GraphDatabaseAPI)this.cluster.getMaster());
    }

    private void createTransactionOn(InstanceId serverId) {
        this.createTransaction((GraphDatabaseAPI)this.cluster.getMemberByServerId(serverId));
    }

    private void createTransaction(GraphDatabaseAPI db) {
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private static class LastTxMapping {
        private final InstanceId serverId;
        private final long txId;

        public LastTxMapping(InstanceId serverId, long txId) {
            this.serverId = serverId;
            this.txId = txId;
        }

        public void format(StringBuilder failures, long txId) {
            if (txId != this.txId) {
                if (failures.length() > 0) {
                    failures.append(", ");
                }
                failures.append(String.format("tx id on server:%d, expected [%d] but was [%d]", this.serverId.toIntegerIndex(), this.txId, txId));
            }
        }
    }
}

