/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock.forseti;

import junit.framework.Assert;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.ha.lock.forseti.ForsetiClient;
import org.neo4j.kernel.ha.lock.forseti.SharedLock;

public class SharedLockTest {
    @Test
    public void shouldUpgradeToUpdateLock() throws Exception {
        ForsetiClient clientA = (ForsetiClient)Mockito.mock(ForsetiClient.class);
        ForsetiClient clientB = (ForsetiClient)Mockito.mock(ForsetiClient.class);
        SharedLock lock = new SharedLock(clientA);
        lock.acquire(clientB);
        Assert.assertTrue((boolean)lock.tryAcquireUpdateLock(clientA));
        MatcherAssert.assertThat((Object)lock.numberOfHolders(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)lock.isUpdateLock(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldReleaseSharedLock() throws Exception {
        ForsetiClient clientA = (ForsetiClient)Mockito.mock(ForsetiClient.class);
        SharedLock lock = new SharedLock(clientA);
        Assert.assertTrue((boolean)lock.release(clientA));
        MatcherAssert.assertThat((Object)lock.numberOfHolders(), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)lock.isUpdateLock(), (Matcher)Matchers.equalTo((Object)false));
    }
}

