/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.ha;

import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.cluster.InstanceId;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.ReadOnlyDbException;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.ha.ClusterManager;

public class ReadOnlySlaveTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenClusterWithReadOnlySlaveWhenWriteTxOnSlaveThenCommitFails() throws Throwable {
        Map config = MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_factor.name(), "2"});
        ClusterManager clusterManager = new ClusterManager.Builder(this.folder.getRoot()).withCommonConfig(config).withInstanceConfig(2, MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.read_only.name(), "true"})).build();
        try {
            clusterManager.start();
            ClusterManager.ManagedCluster cluster = clusterManager.getDefaultCluster();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase readOnlySlave = cluster.getMemberByServerId(new InstanceId(2));
            try (Transaction tx = readOnlySlave.beginTx();){
                readOnlySlave.createNode();
                tx.success();
            }
            catch (TransactionFailureException ex) {
                Assert.assertThat((Object)ex.getCause(), (Matcher)CoreMatchers.instanceOf(ReadOnlyDbException.class));
            }
        }
        finally {
            clusterManager.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenClusterWithReadOnlySlaveWhenChangePropertyOnSlaveThenThrowException() throws Throwable {
        Map config = MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_factor.name(), "2"});
        ClusterManager clusterManager = new ClusterManager.Builder(this.folder.getRoot()).withCommonConfig(config).withInstanceConfig(2, MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.read_only.name(), "true"})).build();
        try {
            Node node;
            clusterManager.start();
            ClusterManager.ManagedCluster cluster = clusterManager.getDefaultCluster();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            try (Transaction tx = master.beginTx();){
                node = master.createNode();
                tx.success();
            }
            HighlyAvailableGraphDatabase readOnlySlave = cluster.getMemberByServerId(new InstanceId(2));
            try (Transaction tx = readOnlySlave.beginTx();){
                Node slaveNode = readOnlySlave.getNodeById(node.getId());
                slaveNode.setProperty("foo", (Object)"bar");
                tx.success();
            }
            catch (TransactionFailureException ex) {
                Assert.assertThat((Object)ex.getCause(), (Matcher)CoreMatchers.instanceOf(ReadOnlyDbException.class));
            }
        }
        finally {
            clusterManager.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenClusterWithReadOnlySlaveWhenAddNewLabelOnSlaveThenThrowException() throws Throwable {
        Map config = MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_factor.name(), "2"});
        ClusterManager clusterManager = new ClusterManager.Builder(this.folder.getRoot()).withCommonConfig(config).withInstanceConfig(2, MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.read_only.name(), "true"})).build();
        try {
            Node node;
            clusterManager.start();
            ClusterManager.ManagedCluster cluster = clusterManager.getDefaultCluster();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            try (Transaction tx = master.beginTx();){
                node = master.createNode();
                tx.success();
            }
            HighlyAvailableGraphDatabase readOnlySlave = cluster.getMemberByServerId(new InstanceId(2));
            try (Transaction tx = readOnlySlave.beginTx();){
                Node slaveNode = readOnlySlave.getNodeById(node.getId());
                slaveNode.addLabel(DynamicLabel.label((String)"FOO"));
                tx.success();
            }
            catch (TransactionFailureException ex) {
                Assert.assertThat((Object)ex.getCause(), (Matcher)CoreMatchers.instanceOf(ReadOnlyDbException.class));
            }
        }
        finally {
            clusterManager.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenClusterWithReadOnlySlaveWhenAddNewRelTypeOnSlaveThenThrowException() throws Throwable {
        Map config = MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_factor.name(), "2"});
        ClusterManager clusterManager = new ClusterManager.Builder(this.folder.getRoot()).withCommonConfig(config).withInstanceConfig(2, MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.read_only.name(), "true"})).build();
        try {
            Node node2;
            Node node;
            clusterManager.start();
            ClusterManager.ManagedCluster cluster = clusterManager.getDefaultCluster();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            try (Transaction tx = master.beginTx();){
                node = master.createNode();
                node2 = master.createNode();
                tx.success();
            }
            HighlyAvailableGraphDatabase readOnlySlave = cluster.getMemberByServerId(new InstanceId(2));
            try (Transaction tx = readOnlySlave.beginTx();){
                Node slaveNode = readOnlySlave.getNodeById(node.getId());
                Node slaveNode2 = readOnlySlave.getNodeById(node2.getId());
                slaveNode.createRelationshipTo(slaveNode2, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"));
                tx.success();
            }
            catch (TransactionFailureException ex) {
                Assert.assertThat((Object)ex.getCause(), (Matcher)CoreMatchers.instanceOf(ReadOnlyDbException.class));
            }
        }
        finally {
            clusterManager.shutdown();
        }
    }
}

