/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.ha;

import com.sun.management.GarbageCollectionNotificationInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RetryOnGcRule
implements TestRule {
    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                final AtomicLong periodGcDuration = new AtomicLong();
                NotificationListener listener = new NotificationListener(){

                    @Override
                    public void handleNotification(Notification notification, Object handback) {
                        if (notification.getType().equals("com.sun.management.gc.notification")) {
                            GarbageCollectionNotificationInfo info = GarbageCollectionNotificationInfo.from((CompositeData)notification.getUserData());
                            long duration = info.getGcInfo().getDuration();
                            periodGcDuration.addAndGet(duration);
                        }
                    }
                };
                List<GarbageCollectorMXBean> gcbeans = ManagementFactory.getGarbageCollectorMXBeans();
                for (GarbageCollectorMXBean gcbean : gcbeans) {
                    NotificationEmitter emitter = (NotificationEmitter)((Object)gcbean);
                    emitter.addNotificationListener(listener, null, null);
                }
                try {
                    Throwable e = null;
                    for (int i = 0; i < 5; ++i) {
                        try {
                            base.evaluate();
                            return;
                        }
                        catch (Throwable ex) {
                            e = ex;
                            ex.printStackTrace();
                            if (periodGcDuration.get() < TimeUnit.SECONDS.toMillis(5L)) {
                                throw ex;
                            }
                            periodGcDuration.set(0L);
                            continue;
                        }
                    }
                    throw e;
                }
                finally {
                    for (GarbageCollectorMXBean gcbean : gcbeans) {
                        NotificationEmitter emitter = (NotificationEmitter)((Object)gcbean);
                        emitter.removeNotificationListener(listener, null, null);
                    }
                }
            }
        };
    }
}

