/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.net.InetSocketAddress;
import java.net.URI;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.com.Server;
import org.neo4j.com.ServerUtil;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.Provider;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.BranchDetectingTxVerifier;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.TransactionChecksumLookup;
import org.neo4j.kernel.ha.cluster.DefaultMasterImplSPI;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.master.MasterImpl;
import org.neo4j.kernel.ha.com.master.MasterServer;
import org.neo4j.kernel.ha.com.master.SlaveFactory;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;

public class SwitchToMaster
implements AutoCloseable {
    private Logging logging;
    private ConsoleLogger console;
    private GraphDatabaseAPI graphDb;
    private HaIdGeneratorFactory idGeneratorFactory;
    private Config config;
    private Provider<SlaveFactory> slaveFactorySupplier;
    private MasterImpl.Monitor masterImplMonitor;
    private DelegateInvocationHandler<Master> masterDelegateHandler;
    private ClusterMemberAvailability clusterMemberAvailability;
    private DataSourceManager dataSourceManager;
    private ByteCounterMonitor masterByteCounterMonitor;
    private RequestMonitor masterRequestMonitor;

    public SwitchToMaster(Logging logging, ConsoleLogger console, GraphDatabaseAPI graphDb, HaIdGeneratorFactory idGeneratorFactory, Config config, Provider<SlaveFactory> slaveFactorySupplier, DelegateInvocationHandler<Master> masterDelegateHandler, ClusterMemberAvailability clusterMemberAvailability, DataSourceManager dataSourceManager, ByteCounterMonitor masterByteCounterMonitor, RequestMonitor masterRequestMonitor, MasterImpl.Monitor masterImplMonitor) {
        this.logging = logging;
        this.console = console;
        this.graphDb = graphDb;
        this.idGeneratorFactory = idGeneratorFactory;
        this.config = config;
        this.slaveFactorySupplier = slaveFactorySupplier;
        this.masterImplMonitor = masterImplMonitor;
        this.masterDelegateHandler = masterDelegateHandler;
        this.clusterMemberAvailability = clusterMemberAvailability;
        this.dataSourceManager = dataSourceManager;
        this.masterByteCounterMonitor = masterByteCounterMonitor;
        this.masterRequestMonitor = masterRequestMonitor;
    }

    public URI switchToMaster(LifeSupport haCommunicationLife, URI me) {
        this.console.log("I am " + this.myId() + ", moving to master");
        this.idGeneratorFactory.switchToMaster();
        NeoStoreDataSource neoStoreXaDataSource = this.dataSourceManager.getDataSource();
        neoStoreXaDataSource.afterModeSwitch();
        DefaultMasterImplSPI spi = new DefaultMasterImplSPI(this.graphDb);
        MasterImpl masterImpl = new MasterImpl(spi, this.masterImplMonitor, this.logging, this.config);
        DependencyResolver resolver = neoStoreXaDataSource.getDependencyResolver();
        TransactionChecksumLookup txChecksumLookup = new TransactionChecksumLookup((TransactionIdStore)resolver.resolveDependency(TransactionIdStore.class), (LogicalTransactionStore)resolver.resolveDependency(LogicalTransactionStore.class));
        MasterServer masterServer = new MasterServer(masterImpl, this.logging, this.serverConfig(), new BranchDetectingTxVerifier(this.logging.getMessagesLog(BranchDetectingTxVerifier.class), txChecksumLookup), this.masterByteCounterMonitor, this.masterRequestMonitor);
        haCommunicationLife.add((Object)masterImpl);
        haCommunicationLife.add((Object)masterServer);
        this.masterDelegateHandler.setDelegate(masterImpl);
        haCommunicationLife.start();
        URI masterHaURI = this.getMasterUri(me, masterServer);
        this.clusterMemberAvailability.memberIsAvailable("master", masterHaURI, neoStoreXaDataSource.getStoreId());
        this.console.log("I am " + this.myId() + ", successfully moved to master");
        ((SlaveFactory)this.slaveFactorySupplier.instance()).setStoreId(neoStoreXaDataSource.getStoreId());
        return masterHaURI;
    }

    private URI getMasterUri(URI me, MasterServer masterServer) {
        String hostname = ServerUtil.getHostString((InetSocketAddress)masterServer.getSocketAddress()).contains("0.0.0.0") ? me.getHost() : ServerUtil.getHostString((InetSocketAddress)masterServer.getSocketAddress());
        int port = masterServer.getSocketAddress().getPort();
        return URI.create("ha://" + hostname + ":" + port + "?serverId=" + this.myId());
    }

    private Server.Configuration serverConfig() {
        Server.Configuration serverConfig = new Server.Configuration(){

            public long getOldChannelThreshold() {
                return (Long)SwitchToMaster.this.config.get(HaSettings.lock_read_timeout);
            }

            public int getMaxConcurrentTransactions() {
                return (Integer)SwitchToMaster.this.config.get(HaSettings.max_concurrent_channels_per_slave);
            }

            public int getChunkSize() {
                return ((Long)SwitchToMaster.this.config.get(HaSettings.com_chunk_size)).intValue();
            }

            public HostnamePort getServerAddress() {
                return (HostnamePort)SwitchToMaster.this.config.get(HaSettings.ha_server);
            }
        };
        return serverConfig;
    }

    private InstanceId myId() {
        return (InstanceId)this.config.get(ClusterSettings.server_id);
    }

    @Override
    public void close() throws Exception {
        this.logging = null;
        this.console = null;
        this.graphDb = null;
        this.idGeneratorFactory = null;
        this.config = null;
        this.slaveFactorySupplier = null;
        this.masterImplMonitor = null;
        this.masterDelegateHandler = null;
        this.clusterMemberAvailability = null;
        this.dataSourceManager = null;
        this.masterByteCounterMonitor = null;
        this.masterRequestMonitor = null;
    }
}

