/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.LastUpdateTime;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.UpdatePullerClient;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.InvalidEpochException;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.slave.InvalidEpochExceptionHandler;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.logging.BufferingLogger;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.LogMarker;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.test.CleanupRule;
import org.neo4j.test.OnDemandJobScheduler;

public class UpdatePullerTest {
    private final InstanceId myId = new InstanceId(1);
    private final CapturingHighAvailabilityMemberStateMachine stateMachine = new CapturingHighAvailabilityMemberStateMachine(this.myId);
    private final OnDemandJobScheduler scheduler = new OnDemandJobScheduler();
    private final Config config = (Config)Mockito.mock(Config.class);
    private final AvailabilityGuard availabilityGuard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
    private final LastUpdateTime lastUpdateTime = (LastUpdateTime)Mockito.mock(LastUpdateTime.class);
    private final Master master = (Master)Mockito.mock(Master.class);
    private final ErrorTrackingLogging logging = new ErrorTrackingLogging();
    private final RequestContextFactory requestContextFactory = (RequestContextFactory)Mockito.mock(RequestContextFactory.class);
    private final InvalidEpochExceptionHandler invalidEpochHandler = (InvalidEpochExceptionHandler)Mockito.mock(InvalidEpochExceptionHandler.class);
    private final UpdatePuller updatePuller = new UpdatePuller((HighAvailabilityMemberStateMachine)this.stateMachine, this.requestContextFactory, this.master, this.lastUpdateTime, (Logging)this.logging, this.myId, this.invalidEpochHandler);
    @Rule
    public final CleanupRule cleanup = new CleanupRule();

    @Before
    public void setup() throws Throwable {
        Mockito.when((Object)this.config.get(HaSettings.pull_interval)).thenReturn((Object)1000L);
        Mockito.when((Object)this.config.get(ClusterSettings.server_id)).thenReturn((Object)this.myId);
        Mockito.when((Object)this.availabilityGuard.isAvailable(Matchers.anyLong())).thenReturn((Object)true);
        this.updatePuller.init();
        this.updatePuller.start();
    }

    @Test
    public void shouldNotStartPullingUpdatesUntilStartIsCalled() throws Throwable {
        UpdatePullerClient puller = new UpdatePullerClient(1L, (JobScheduler)this.scheduler, (Logging)this.logging, this.updatePuller, this.availabilityGuard);
        puller.init();
        Assert.assertNotNull((Object)this.scheduler.getJob());
        this.scheduler.runJob();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.lastUpdateTime, this.availabilityGuard});
    }

    @Test
    public void shouldStartAndStopPullingUpdatesWhenStartAndStopIsCalled() throws Throwable {
        UpdatePullerClient puller = new UpdatePullerClient(1L, (JobScheduler)this.scheduler, (Logging)this.logging, this.updatePuller, this.availabilityGuard);
        puller.init();
        Assert.assertNotNull((Object)this.scheduler.getJob());
        puller.start();
        this.updatePuller.unpause();
        this.scheduler.runJob();
        ((LastUpdateTime)Mockito.verify((Object)this.lastUpdateTime, (VerificationMode)Mockito.times((int)1))).setLastUpdateTime(Matchers.anyLong());
        ((AvailabilityGuard)Mockito.verify((Object)this.availabilityGuard, (VerificationMode)Mockito.times((int)1))).isAvailable(Matchers.anyLong());
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)1))).pullUpdates((RequestContext)Matchers.any());
        this.updatePuller.stop();
        this.scheduler.runJob();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.lastUpdateTime, this.availabilityGuard});
    }

    @Test
    public void shouldStopPullingUpdatesWhenThisInstanceBecomesTheMaster() throws Throwable {
        UpdatePullerClient puller = new UpdatePullerClient(1L, (JobScheduler)this.scheduler, (Logging)this.logging, this.updatePuller, this.availabilityGuard);
        puller.init();
        puller.start();
        this.updatePuller.unpause();
        this.scheduler.runJob();
        ((LastUpdateTime)Mockito.verify((Object)this.lastUpdateTime, (VerificationMode)Mockito.times((int)1))).setLastUpdateTime(Matchers.anyLong());
        ((AvailabilityGuard)Mockito.verify((Object)this.availabilityGuard, (VerificationMode)Mockito.times((int)1))).isAvailable(Matchers.anyLong());
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)1))).pullUpdates((RequestContext)Matchers.any());
        this.stateMachine.masterIsElected();
        this.scheduler.runJob();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.lastUpdateTime, this.availabilityGuard});
    }

    @Test
    public void shouldKeepPullingUpdatesWhenThisInstanceBecomesASlave() throws Throwable {
        UpdatePullerClient puller = new UpdatePullerClient(1L, (JobScheduler)this.scheduler, (Logging)this.logging, this.updatePuller, this.availabilityGuard);
        puller.init();
        puller.start();
        this.updatePuller.unpause();
        this.scheduler.runJob();
        ((LastUpdateTime)Mockito.verify((Object)this.lastUpdateTime, (VerificationMode)Mockito.times((int)1))).setLastUpdateTime(Matchers.anyLong());
        ((AvailabilityGuard)Mockito.verify((Object)this.availabilityGuard, (VerificationMode)Mockito.times((int)1))).isAvailable(Matchers.anyLong());
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)1))).pullUpdates((RequestContext)Matchers.any());
        this.scheduler.runJob();
        ((LastUpdateTime)Mockito.verify((Object)this.lastUpdateTime, (VerificationMode)Mockito.times((int)2))).setLastUpdateTime(Matchers.anyLong());
        ((AvailabilityGuard)Mockito.verify((Object)this.availabilityGuard, (VerificationMode)Mockito.times((int)2))).isAvailable(Matchers.anyLong());
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)2))).pullUpdates((RequestContext)Matchers.any());
    }

    @Test
    public void shouldResumePullingUpdatesWhenThisInstanceSwitchesFromMasterToSlave() throws Throwable {
        UpdatePullerClient puller = new UpdatePullerClient(1L, (JobScheduler)this.scheduler, (Logging)this.logging, this.updatePuller, this.availabilityGuard);
        puller.init();
        puller.start();
        this.updatePuller.unpause();
        this.scheduler.runJob();
        ((LastUpdateTime)Mockito.verify((Object)this.lastUpdateTime, (VerificationMode)Mockito.times((int)1))).setLastUpdateTime(Matchers.anyLong());
        ((AvailabilityGuard)Mockito.verify((Object)this.availabilityGuard, (VerificationMode)Mockito.times((int)1))).isAvailable(Matchers.anyLong());
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)1))).pullUpdates((RequestContext)Matchers.any());
        this.stateMachine.masterIsElected();
        this.scheduler.runJob();
        this.updatePuller.unpause();
        this.scheduler.runJob();
        ((LastUpdateTime)Mockito.verify((Object)this.lastUpdateTime, (VerificationMode)Mockito.times((int)2))).setLastUpdateTime(Matchers.anyLong());
        ((AvailabilityGuard)Mockito.verify((Object)this.availabilityGuard, (VerificationMode)Mockito.times((int)2))).isAvailable(Matchers.anyLong());
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)2))).pullUpdates((RequestContext)Matchers.any());
    }

    @Test
    public void shouldResumePullingUpdatesWhenThisInstanceSwitchesFromSlaveToMaster() throws Throwable {
        UpdatePullerClient puller = new UpdatePullerClient(1L, (JobScheduler)this.scheduler, (Logging)this.logging, this.updatePuller, this.availabilityGuard);
        puller.init();
        puller.start();
        this.updatePuller.unpause();
        this.scheduler.runJob();
        ((LastUpdateTime)Mockito.verify((Object)this.lastUpdateTime, (VerificationMode)Mockito.times((int)1))).setLastUpdateTime(Matchers.anyLong());
        ((AvailabilityGuard)Mockito.verify((Object)this.availabilityGuard, (VerificationMode)Mockito.times((int)1))).isAvailable(Matchers.anyLong());
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)1))).pullUpdates((RequestContext)Matchers.any());
        this.scheduler.runJob();
        ((LastUpdateTime)Mockito.verify((Object)this.lastUpdateTime, (VerificationMode)Mockito.times((int)2))).setLastUpdateTime(Matchers.anyLong());
        ((AvailabilityGuard)Mockito.verify((Object)this.availabilityGuard, (VerificationMode)Mockito.times((int)2))).isAvailable(Matchers.anyLong());
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)2))).pullUpdates((RequestContext)Matchers.any());
        this.stateMachine.masterIsElected();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.lastUpdateTime, this.availabilityGuard});
    }

    @Test
    public void shouldReturnFalseIfPullerInitiallyInactiveNonStrict() throws Exception {
        UpdatePuller.Condition condition = (UpdatePuller.Condition)Mockito.mock(UpdatePuller.Condition.class);
        this.updatePuller.pause();
        boolean result = this.updatePuller.await(condition, false);
        Assert.assertFalse((boolean)result);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{condition});
    }

    @Test
    public void shouldReturnFalseIfPullerBecomesInactiveWhileWaitingNonStrict() throws Exception {
        UpdatePuller.Condition condition = (UpdatePuller.Condition)Mockito.mock(UpdatePuller.Condition.class);
        this.updatePuller.unpause();
        Mockito.when((Object)condition.evaluate(Matchers.anyInt(), Matchers.anyInt())).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                UpdatePullerTest.this.updatePuller.pause();
                return false;
            }
        });
        boolean result = this.updatePuller.await(condition, false);
        Assert.assertFalse((boolean)result);
        ((UpdatePuller.Condition)Mockito.verify((Object)condition, (VerificationMode)Mockito.times((int)1))).evaluate(Matchers.anyInt(), Matchers.anyInt());
    }

    @Test
    public void shouldThrowIfPullerInitiallyInactiveStrict() throws Exception {
        UpdatePuller.Condition condition = (UpdatePuller.Condition)Mockito.mock(UpdatePuller.Condition.class);
        this.updatePuller.pause();
        try {
            this.updatePuller.await(condition, true);
            Assert.fail((String)"Should have thrown");
        }
        catch (IllegalStateException e) {
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{condition});
        }
    }

    @Test
    public void shouldThrowIfPullerBecomesInactiveWhileWaitingStrict() throws Exception {
        UpdatePuller.Condition condition = (UpdatePuller.Condition)Mockito.mock(UpdatePuller.Condition.class);
        this.updatePuller.unpause();
        Mockito.when((Object)condition.evaluate(Matchers.anyInt(), Matchers.anyInt())).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                UpdatePullerTest.this.updatePuller.pause();
                return false;
            }
        });
        try {
            this.updatePuller.await(condition, true);
            Assert.fail((String)"Should have thrown");
        }
        catch (IllegalStateException e) {
            ((UpdatePuller.Condition)Mockito.verify((Object)condition, (VerificationMode)Mockito.times((int)1))).evaluate(Matchers.anyInt(), Matchers.anyInt());
        }
    }

    @Test
    public void shouldHandleInvalidEpochByNotifyingItsHandler() throws Exception {
        ((Master)Mockito.doThrow(InvalidEpochException.class).when((Object)this.master)).pullUpdates((RequestContext)Matchers.any(RequestContext.class));
        this.updatePuller.unpause();
        this.updatePuller.await(UpdatePuller.NEXT_TICKET, true);
        ((InvalidEpochExceptionHandler)Mockito.verify((Object)this.invalidEpochHandler)).handle();
    }

    @Test
    public void shouldCopeWithHardExceptionsLikeOutOfMemory() throws Exception {
        Mockito.when((Object)this.master.pullUpdates((RequestContext)Matchers.any(RequestContext.class))).thenThrow(new Class[]{OutOfMemoryError.class}).thenReturn((Object)Response.EMPTY);
        this.updatePuller.unpause();
        this.updatePuller.await(UpdatePuller.NEXT_TICKET, true);
        Assert.assertTrue((boolean)this.logging.hasSeenError(OutOfMemoryError.class));
        this.updatePuller.await(UpdatePuller.NEXT_TICKET, true);
    }

    private static class ErrorTrackingLogger
    extends BufferingLogger {
        private final List<Throwable> errors;

        public ErrorTrackingLogger(List<Throwable> errors) {
            this.errors = errors;
        }

        public synchronized void error(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
            this.errors.add(cause);
            super.error(msg, cause, flush, logMarker);
        }
    }

    private static class ErrorTrackingLogging
    extends LifecycleAdapter
    implements Logging {
        private final List<Throwable> errors = new ArrayList<Throwable>();
        private final StringLogger logger = new ErrorTrackingLogger(this.errors);

        private ErrorTrackingLogging() {
        }

        public StringLogger getMessagesLog(Class loggingClass) {
            return this.logger;
        }

        public ConsoleLogger getConsoleLog(Class loggingClass) {
            throw new UnsupportedOperationException("Shouldn't be required");
        }

        boolean hasSeenError(Class<?> cls) {
            for (Throwable throwable : this.errors) {
                if (!throwable.getClass().equals(cls)) continue;
                return true;
            }
            return false;
        }
    }

    private static class CapturingHighAvailabilityMemberStateMachine
    extends HighAvailabilityMemberStateMachine {
        private final InstanceId myId;
        private final URI uri;
        private final List<HighAvailabilityMemberListener> listeners = new ArrayList<HighAvailabilityMemberListener>();

        public CapturingHighAvailabilityMemberStateMachine(InstanceId myId) {
            super((HighAvailabilityMemberContext)Mockito.mock(HighAvailabilityMemberContext.class), (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class), (ClusterMembers)Mockito.mock(ClusterMembers.class), (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class), (Election)Mockito.mock(Election.class), (StringLogger)Mockito.mock(StringLogger.class));
            this.myId = myId;
            this.uri = URI.create("ha://me");
        }

        public void addHighAvailabilityMemberListener(HighAvailabilityMemberListener toAdd) {
            this.listeners.add(toAdd);
        }

        public void masterIsElected() {
            for (HighAvailabilityMemberListener listener : this.listeners) {
                listener.masterIsElected(new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberState.PENDING, HighAvailabilityMemberState.TO_MASTER, this.myId, this.uri));
            }
        }
    }
}

