/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.kernel.info.DiagnosticsProvider;

public class HighAvailabilityDiagnostics
implements DiagnosticsProvider {
    private final HighAvailabilityMemberStateMachine memberStateMachine;
    private final ClusterClient clusterClient;

    public HighAvailabilityDiagnostics(HighAvailabilityMemberStateMachine memberStateMachine, ClusterClient clusterClient) {
        this.memberStateMachine = memberStateMachine;
        this.clusterClient = clusterClient;
    }

    public String getDiagnosticsIdentifier() {
        return this.getClass().getSimpleName();
    }

    public void acceptDiagnosticsVisitor(Object visitor) {
    }

    public void dump(DiagnosticsPhase phase, StringLogger log) {
        StringBuilder builder = new StringBuilder();
        builder.append("High Availability diagnostics\n").append("Member state:").append(this.memberStateMachine.getCurrentState().name()).append("\n").append("State machines:\n");
        this.clusterClient.dumpDiagnostics(builder);
        log.info(builder.toString());
    }
}

