/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.storecopy.ResponsePacker;
import org.neo4j.com.storecopy.StoreCopyServer;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.Provider;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.ha.TransactionChecksumLookup;
import org.neo4j.kernel.ha.com.master.MasterImpl;
import org.neo4j.kernel.ha.id.IdAllocation;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogRotationControl;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.monitoring.Monitors;

class DefaultMasterImplSPI
implements MasterImpl.SPI {
    private static final int ID_GRAB_SIZE = 1000;
    private final DependencyResolver dependencyResolver;
    private final GraphDatabaseAPI graphDb;
    private final LogicalTransactionStore txStore;
    private final TransactionIdStore transactionIdStore;
    private final TransactionChecksumLookup txChecksumLookup;
    private final FileSystemAbstraction fileSystem;
    private final File storeDir;
    private final ResponsePacker responsePacker;
    private final Monitors monitors;

    public DefaultMasterImplSPI(final GraphDatabaseAPI graphDb) {
        this.graphDb = graphDb;
        this.dependencyResolver = graphDb.getDependencyResolver();
        this.transactionIdStore = (TransactionIdStore)this.dependencyResolver.resolveDependency(TransactionIdStore.class);
        this.fileSystem = (FileSystemAbstraction)this.dependencyResolver.resolveDependency(FileSystemAbstraction.class);
        this.storeDir = new File(graphDb.getStoreDir());
        this.txStore = (LogicalTransactionStore)this.dependencyResolver.resolveDependency(LogicalTransactionStore.class);
        this.txChecksumLookup = new TransactionChecksumLookup(this.transactionIdStore, this.txStore);
        this.responsePacker = new ResponsePacker(this.txStore, this.transactionIdStore, (Provider)new Provider<StoreId>(){

            public StoreId instance() {
                return graphDb.storeId();
            }
        });
        this.monitors = (Monitors)this.dependencyResolver.resolveDependency(Monitors.class);
    }

    @Override
    public boolean isAccessible() {
        return this.graphDb.isAvailable(5000L);
    }

    @Override
    public int getOrCreateLabel(String name) {
        LabelTokenHolder labels = this.resolve(LabelTokenHolder.class);
        return labels.getOrCreateId(name);
    }

    @Override
    public int getOrCreateProperty(String name) {
        PropertyKeyTokenHolder propertyKeyHolder = this.resolve(PropertyKeyTokenHolder.class);
        return propertyKeyHolder.getOrCreateId(name);
    }

    @Override
    public Locks.Client acquireClient() {
        return this.resolve(Locks.class).newClient();
    }

    @Override
    public IdAllocation allocateIds(IdType idType) {
        IdGenerator generator = this.resolve(IdGeneratorFactory.class).get(idType);
        return new IdAllocation(generator.nextIdBatch(1000), generator.getHighId(), generator.getDefragCount());
    }

    @Override
    public StoreId storeId() {
        return this.graphDb.storeId();
    }

    @Override
    public long applyPreparedTransaction(TransactionRepresentation preparedTransaction) throws IOException, TransactionFailureException {
        try (LockGroup locks = new LockGroup();){
            TransactionCommitProcess txCommitProcess = (TransactionCommitProcess)((NeoStoreDataSource)this.dependencyResolver.resolveDependency(NeoStoreDataSource.class)).getDependencyResolver().resolveDependency(TransactionCommitProcess.class);
            long l = txCommitProcess.commit(preparedTransaction, locks, CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
            return l;
        }
    }

    @Override
    public Integer createRelationshipType(String name) {
        return this.resolve(RelationshipTypeTokenHolder.class).getOrCreateId(name);
    }

    @Override
    public long getTransactionChecksum(long txId) throws IOException {
        return this.txChecksumLookup.apply(txId);
    }

    @Override
    public RequestContext flushStoresAndStreamStoreFiles(StoreWriter writer) {
        NeoStoreDataSource dataSource = ((DataSourceManager)this.dependencyResolver.resolveDependency(DataSourceManager.class)).getDataSource();
        StoreCopyServer streamer = new StoreCopyServer(this.transactionIdStore, dataSource, (LogRotationControl)this.dependencyResolver.resolveDependency(LogRotationControl.class), this.fileSystem, this.storeDir, (StoreCopyServer.Monitor)this.monitors.newMonitor(StoreCopyServer.Monitor.class, new String[0]));
        return streamer.flushStoresAndStreamStoreFiles(writer, false);
    }

    @Override
    public <T> Response<T> packTransactionStreamResponse(RequestContext context, T response) {
        return this.responsePacker.packTransactionStreamResponse(context, response);
    }

    @Override
    public <T> Response<T> packTransactionObligationResponse(RequestContext context, T response) {
        return this.responsePacker.packTransactionObligationResponse(context, response);
    }

    @Override
    public JobScheduler.JobHandle scheduleRecurringJob(JobScheduler.Group group, long interval, Runnable job) {
        return this.resolve(JobScheduler.class).scheduleRecurring(group, job, interval, TimeUnit.MILLISECONDS);
    }

    @Override
    public <T> Response<T> packEmptyResponse(T response) {
        return this.responsePacker.packEmptyResponse(response);
    }

    private <T> T resolve(Class<T> dependencyType) {
        return (T)this.dependencyResolver.resolveDependency(dependencyType);
    }
}

