/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.member;

import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.cluster.member.HighAvailabilitySlaves;
import org.neo4j.kernel.ha.com.master.DefaultSlaveFactory;
import org.neo4j.kernel.ha.com.master.Slave;
import org.neo4j.kernel.ha.com.master.SlaveFactory;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.ReflectionUtil;

public class HighAvailabilitySlavesTest {
    private static final InstanceId INSTANCE_ID = new InstanceId(1);
    private static final URI HA_URI = URI.create("ha://server1?serverId=" + INSTANCE_ID.toIntegerIndex());
    private static final URI CLUSTER_URI = URI.create("cluster://server2");

    @Test
    public void shouldRegisterItselfOnMonitors() {
        ClusterMembers clusterMembers = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        SlaveFactory slaveFactory = (SlaveFactory)Mockito.mock(SlaveFactory.class);
        new HighAvailabilitySlaves(clusterMembers, cluster, slaveFactory).init();
        ((Cluster)Mockito.verify((Object)cluster)).addClusterListener((ClusterListener)Matchers.any(ClusterListener.class));
    }

    @Test
    public void shouldNotReturnUnavailableSlaves() {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        ClusterMembers clusterMembers = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        Mockito.when((Object)clusterMembers.getMembers()).thenReturn((Object)Iterables.option((Object)new ClusterMember(INSTANCE_ID)));
        SlaveFactory slaveFactory = (SlaveFactory)Mockito.mock(SlaveFactory.class);
        HighAvailabilitySlaves slaves = new HighAvailabilitySlaves(clusterMembers, cluster, slaveFactory);
        slaves.init();
        Iterable memberSlaves = slaves.getSlaves();
        Assert.assertThat((Object)Iterables.count((Iterable)memberSlaves), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldNotReturnAvailableButFailedSlaves() {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        ClusterMembers clusterMembers = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        Mockito.when((Object)clusterMembers.getMembers()).thenReturn((Object)Iterables.option((Object)new ClusterMember(INSTANCE_ID).availableAs("slave", HA_URI, StoreId.DEFAULT).failed()));
        SlaveFactory slaveFactory = (SlaveFactory)Mockito.mock(SlaveFactory.class);
        HighAvailabilitySlaves slaves = new HighAvailabilitySlaves(clusterMembers, cluster, slaveFactory);
        slaves.init();
        Iterable memberSlaves = slaves.getSlaves();
        Assert.assertThat((Object)Iterables.count((Iterable)memberSlaves), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldReturnAvailableAndAliveSlaves() {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        ClusterMembers clusterMembers = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        Mockito.when((Object)clusterMembers.getMembers()).thenReturn((Object)Iterables.option((Object)new ClusterMember(INSTANCE_ID).availableAs("slave", HA_URI, StoreId.DEFAULT)));
        SlaveFactory slaveFactory = (SlaveFactory)Mockito.mock(SlaveFactory.class);
        Mockito.when((Object)slaveFactory.newSlave((LifeSupport)Matchers.any(LifeSupport.class), (ClusterMember)Matchers.any(ClusterMember.class))).thenReturn(Mockito.mock(Slave.class));
        HighAvailabilitySlaves slaves = new HighAvailabilitySlaves(clusterMembers, cluster, slaveFactory);
        slaves.init();
        Iterable memberSlaves = slaves.getSlaves();
        Assert.assertThat((Object)Iterables.count((Iterable)memberSlaves), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldClearSlavesWhenNewMasterElected() {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        ClusterMembers clusterMembers = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        Mockito.when((Object)clusterMembers.getMembers()).thenReturn((Object)Iterables.option((Object)new ClusterMember(INSTANCE_ID).availableAs("slave", HA_URI, StoreId.DEFAULT)));
        SlaveFactory slaveFactory = (SlaveFactory)Mockito.mock(SlaveFactory.class);
        Mockito.when((Object)slaveFactory.newSlave((LifeSupport)Matchers.any(LifeSupport.class), (ClusterMember)Matchers.any(ClusterMember.class))).thenReturn(Mockito.mock(Slave.class), (Object[])new Slave[]{(Slave)Mockito.mock(Slave.class)});
        HighAvailabilitySlaves slaves = new HighAvailabilitySlaves(clusterMembers, cluster, slaveFactory);
        slaves.init();
        ArgumentCaptor listener = ArgumentCaptor.forClass(ClusterListener.class);
        ((Cluster)Mockito.verify((Object)cluster)).addClusterListener((ClusterListener)listener.capture());
        Slave slave1 = (Slave)slaves.getSlaves().iterator().next();
        ((ClusterListener)listener.getValue()).elected("coordinator", INSTANCE_ID, CLUSTER_URI);
        Slave slave2 = (Slave)slaves.getSlaves().iterator().next();
        Assert.assertThat((Object)slave2, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)slave1)));
    }

    @Test
    public void shouldSupportConcurrentConsumptionOfSlaves() throws Exception {
        HighAvailabilitySlaves haSlaves = new HighAvailabilitySlaves(HighAvailabilitySlavesTest.clusterMembersOfSize(1000), (Cluster)Mockito.mock(Cluster.class), (SlaveFactory)new DefaultSlaveFactory(DevNullLoggingService.DEV_NULL, new Monitors(), 42));
        ExecutorService executor = Executors.newFixedThreadPool(5);
        for (int i = 0; i < 5; ++i) {
            executor.submit(HighAvailabilitySlavesTest.slavesConsumingRunnable(haSlaves));
        }
        executor.shutdown();
        executor.awaitTermination(30L, TimeUnit.SECONDS);
        int slavesCount = 0;
        LifeSupport life = (LifeSupport)ReflectionUtil.getPrivateField((Object)haSlaves, (String)"life", LifeSupport.class);
        for (Lifecycle lifecycle : life.getLifecycleInstances()) {
            if (!(lifecycle instanceof Slave)) continue;
            ++slavesCount;
        }
        Assert.assertEquals((String)"Unexpected number of slaves", (long)999L, (long)slavesCount);
    }

    private static ClusterMembers clusterMembersOfSize(int size) {
        ArrayList<ClusterMember> members = new ArrayList<ClusterMember>(size);
        members.add(HighAvailabilitySlavesTest.mockClusterMemberWithRole("master"));
        for (int i = 0; i < size - 1; ++i) {
            members.add(HighAvailabilitySlavesTest.mockClusterMemberWithRole("slave"));
        }
        ClusterMembers clusterMembers = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        Mockito.when((Object)clusterMembers.getMembers()).thenReturn(members);
        return clusterMembers;
    }

    private static ClusterMember mockClusterMemberWithRole(String role) {
        ClusterMember member = (ClusterMember)Mockito.mock(ClusterMember.class);
        Mockito.when((Object)member.getHAUri()).thenReturn((Object)URI.create("http://localhost:7474"));
        Mockito.when((Object)member.isAlive()).thenReturn((Object)true);
        Mockito.when((Object)member.hasRole((String)Matchers.eq((Object)role))).thenReturn((Object)true);
        return member;
    }

    private static Runnable slavesConsumingRunnable(final HighAvailabilitySlaves haSlaves) {
        return new Runnable(){

            @Override
            public void run() {
                for (Slave slave : haSlaves.getSlaves()) {
                    Assert.assertNotNull((Object)slave);
                }
            }
        };
    }
}

