/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.HighPerformanceCacheSettings;
import org.neo4j.kernel.impl.core.Caches;
import org.neo4j.test.TestGraphDatabaseFactory;

@Ignore(value="Impermanent graph database doesn't use High-Performance Cache")
public class TestCacheObjectReuse {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void highPerformanceCachesCanBeReusedBetweenSessions() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.cache_type, "hpc").newGraphDatabase();
        Cache<?> firstCache = this.firstCache(db);
        db.shutdown();
        db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.cache_type, "hpc").newGraphDatabase();
        try {
            Cache<?> secondCache = this.firstCache(db);
            Assert.assertEquals(firstCache, secondCache);
        }
        finally {
            db.shutdown();
        }
    }

    private Cache<?> firstCache(GraphDatabaseAPI db) {
        return ((Caches)db.getDependencyResolver().resolveDependency(Caches.class)).node();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void highPerformanceCachesAreRecreatedBetweenSessionsIfConfigChanges() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.cache_type, "hpc").newGraphDatabase();
        Cache<?> firstCache = this.firstCache(db);
        db.shutdown();
        db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.cache_type, "hpc").setConfig(HighPerformanceCacheSettings.node_cache_array_fraction, "10").newGraphDatabase();
        try {
            Cache<?> secondCache = this.firstCache(db);
            Assert.assertFalse((boolean)firstCache.equals(secondCache));
        }
        finally {
            db.shutdown();
        }
    }
}

