/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.net.URI;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.logging.ConsoleLogger;

public class HighAvailabilityConsoleLogger
implements ClusterMemberListener,
ClusterListener,
AvailabilityGuard.AvailabilityListener {
    private final ConsoleLogger console;
    private final InstanceId myId;
    private URI myUri;

    public HighAvailabilityConsoleLogger(ConsoleLogger console, InstanceId myId) {
        this.console = console;
        this.myId = myId;
    }

    public void enteredCluster(ClusterConfiguration clusterConfiguration) {
        this.myUri = clusterConfiguration.getUriForId(this.myId);
        this.console.log(String.format("Instance %s joined the cluster", this.printId(this.myId, this.myUri)));
    }

    public void leftCluster() {
        this.console.log(String.format("Instance %s left the cluster", this.printId(this.myId, this.myUri)));
    }

    public void joinedCluster(InstanceId instanceId, URI member) {
        this.console.log("Instance " + this.printId(instanceId, member) + " joined the cluster");
    }

    public void leftCluster(InstanceId instanceId, URI member) {
        this.console.log("Instance " + this.printId(instanceId, member) + " has left the cluster");
    }

    public void elected(String role, InstanceId instanceId, URI electedMember) {
        this.console.log("Instance " + this.printId(instanceId, electedMember) + "was elected as " + role);
    }

    public void unelected(String role, InstanceId instanceId, URI electedMember) {
        this.console.log("Instance " + this.printId(instanceId, electedMember) + "was demoted as " + role);
    }

    public void coordinatorIsElected(InstanceId coordinatorId) {
    }

    public void memberIsAvailable(String role, InstanceId availableId, URI atUri, StoreId storeId) {
        this.console.log("Instance " + this.printId(availableId, atUri) + "is available as " + role + " at " + atUri.toASCIIString() + " with " + storeId);
    }

    public void memberIsUnavailable(String role, InstanceId unavailableId) {
        this.console.log("Instance " + this.printId(unavailableId, null) + "is unavailable as " + role);
    }

    public void memberIsFailed(InstanceId instanceId) {
        this.console.log("Instance " + this.printId(instanceId, null) + "has failed");
    }

    public void memberIsAlive(InstanceId instanceId) {
        this.console.log("Instance " + this.printId(instanceId, null) + "is alive");
    }

    public void available() {
        this.console.log("Database available for write transactions");
    }

    public void unavailable() {
        this.console.log("Write transactions to database disabled");
    }

    private String printId(InstanceId id, URI member) {
        String name = id.instanceNameFromURI(member);
        return name + (id.equals((Object)this.myId) ? " (this server) " : " ");
    }
}

