/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.neo4j.helpers.Provider;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.SlaveLabelTokenCreator;
import org.neo4j.kernel.ha.cluster.AbstractModeSwitcher;
import org.neo4j.kernel.ha.cluster.ModeSwitcherNotifier;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.impl.core.DefaultLabelIdCreator;
import org.neo4j.kernel.impl.core.TokenCreator;
import org.neo4j.kernel.lifecycle.LifeSupport;

public class LabelTokenCreatorModeSwitcher
extends AbstractModeSwitcher<TokenCreator> {
    private final DelegateInvocationHandler<Master> master;
    private final RequestContextFactory requestContextFactory;
    private final Provider<KernelAPI> kernelProvider;
    private final IdGeneratorFactory idGeneratorFactory;

    public LabelTokenCreatorModeSwitcher(ModeSwitcherNotifier modeSwitcherNotifier, DelegateInvocationHandler<TokenCreator> delegate, DelegateInvocationHandler<Master> master, RequestContextFactory requestContextFactory, Provider<KernelAPI> kernelProvider, IdGeneratorFactory idGeneratorFactory) {
        super(modeSwitcherNotifier, delegate);
        this.master = master;
        this.requestContextFactory = requestContextFactory;
        this.kernelProvider = kernelProvider;
        this.idGeneratorFactory = idGeneratorFactory;
    }

    @Override
    protected TokenCreator getMasterImpl(LifeSupport life) {
        return new DefaultLabelIdCreator(this.kernelProvider, this.idGeneratorFactory);
    }

    @Override
    protected TokenCreator getSlaveImpl(LifeSupport life) {
        return new SlaveLabelTokenCreator(this.master.cement(), this.requestContextFactory);
    }
}

