/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.cluster.InstanceId;
import org.neo4j.com.ComException;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.ha.LastUpdateTime;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.InvalidEpochException;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.slave.InvalidEpochExceptionHandler;
import org.neo4j.kernel.impl.util.CappedOperation;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.logging.Logging;

public class SlaveUpdatePuller
extends LifecycleAdapter
implements Runnable,
UpdatePuller {
    public static String UPDATE_PULLER_THREAD_PREFIX = "UpdatePuller@";
    static final UpdatePuller.Condition NEXT_TICKET = new UpdatePuller.Condition(){

        @Override
        public boolean evaluate(int currentTicket, int targetTicket) {
            return currentTicket >= targetTicket;
        }
    };
    private volatile boolean halted;
    private final AtomicInteger targetTicket = new AtomicInteger();
    private final AtomicInteger currentTicket = new AtomicInteger();
    private final RequestContextFactory requestContextFactory;
    private final Master master;
    private final StringLogger logger;
    private final CappedOperation<Pair<String, ? extends Exception>> cappedLogger;
    private final LastUpdateTime lastUpdateTime;
    private final InstanceId instanceId;
    private final AvailabilityGuard availabilityGuard;
    private InvalidEpochExceptionHandler invalidEpochHandler;
    private Thread me;

    SlaveUpdatePuller(RequestContextFactory requestContextFactory, Master master, LastUpdateTime lastUpdateTime, Logging logging, InstanceId instanceId, AvailabilityGuard availabilityGuard, InvalidEpochExceptionHandler invalidEpochHandler) {
        this.requestContextFactory = requestContextFactory;
        this.master = master;
        this.lastUpdateTime = lastUpdateTime;
        this.instanceId = instanceId;
        this.availabilityGuard = availabilityGuard;
        this.invalidEpochHandler = invalidEpochHandler;
        this.logger = logging.getMessagesLog(this.getClass());
        this.cappedLogger = new CappedOperation<Pair<String, ? extends Exception>>(new CappedOperation.Switch[]{CappedOperation.count((long)10L)}){

            protected void triggered(Pair<String, ? extends Exception> event) {
                SlaveUpdatePuller.this.logger.warn((String)event.first(), (Throwable)event.other());
            }
        };
    }

    @Override
    public void run() {
        while (!this.halted) {
            int round = this.targetTicket.get();
            if (this.currentTicket.get() < round) {
                this.doPullUpdates();
                this.currentTicket.set(round);
                continue;
            }
            LockSupport.parkNanos(100000000L);
        }
    }

    public void init() throws Throwable {
        this.me = new Thread((Runnable)this, UPDATE_PULLER_THREAD_PREFIX + this.instanceId);
        this.me.start();
    }

    public void shutdown() throws Throwable {
        this.halted = true;
        while (this.me.getState() != Thread.State.TERMINATED) {
            Thread.sleep(1L);
            Thread.yield();
        }
        this.invalidEpochHandler = null;
        this.me = null;
    }

    @Override
    public void pullUpdates() throws InterruptedException {
        if (!this.isActive() || !this.availabilityGuard.isAvailable(5000L)) {
            return;
        }
        this.tryPullUpdates();
    }

    @Override
    public boolean tryPullUpdates() throws InterruptedException {
        return this.await(NEXT_TICKET, false);
    }

    @Override
    public void pullUpdates(UpdatePuller.Condition condition, boolean strictlyAssertActive) throws InterruptedException {
        this.await(condition, strictlyAssertActive);
    }

    private boolean await(UpdatePuller.Condition condition, boolean strictlyAssertActive) throws InterruptedException {
        if (!this.checkActive(strictlyAssertActive)) {
            return false;
        }
        int ticket = this.poke();
        while (!condition.evaluate(this.currentTicket.get(), ticket)) {
            if (!this.checkActive(strictlyAssertActive)) {
                return false;
            }
            Thread.sleep(1L);
        }
        return true;
    }

    private boolean checkActive(boolean strictlyAssertActive) {
        if (!this.isActive()) {
            if (strictlyAssertActive) {
                throw new IllegalStateException(this + " is not active");
            }
            return false;
        }
        return true;
    }

    private int poke() {
        int result = this.targetTicket.incrementAndGet();
        LockSupport.unpark(this.me);
        return result;
    }

    public boolean isActive() {
        return !this.halted;
    }

    public String toString() {
        return "UpdatePuller[halted:" + this.halted + ", current:" + this.currentTicket + ", target:" + this.targetTicket + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPullUpdates() {
        try {
            RequestContext context = this.requestContextFactory.newRequestContext();
            Response<Void> ignored = this.master.pullUpdates(context);
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        catch (InvalidEpochException e) {
            this.invalidEpochHandler.handle();
            this.cappedLogger.event((Object)Pair.of((Object)("Pull updates by " + this + " failed at the epoch check"), (Object)((Object)e)));
        }
        catch (ComException e) {
            this.cappedLogger.event((Object)Pair.of((Object)("Pull updates by " + this + " failed due to network error."), (Object)((Object)e)));
        }
        catch (Throwable e) {
            this.logger.error("Pull updates by " + this + " failed", e);
        }
        this.lastUpdateTime.setLastUpdateTime(System.currentTimeMillis());
    }
}

