/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import org.neo4j.function.primitive.FunctionFromPrimitiveLongToPrimitiveLong;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;

public class TransactionChecksumLookup
implements FunctionFromPrimitiveLongToPrimitiveLong<IOException> {
    private final TransactionIdStore transactionIdStore;
    private final LogicalTransactionStore logicalTransactionStore;

    public TransactionChecksumLookup(TransactionIdStore transactionIdStore, LogicalTransactionStore logicalTransactionStore) {
        this.transactionIdStore = transactionIdStore;
        this.logicalTransactionStore = logicalTransactionStore;
    }

    public long apply(long txId) throws IOException {
        TransactionId lastCommittedTransaction = this.transactionIdStore.getLastCommittedTransaction();
        if (lastCommittedTransaction.transactionId() == txId) {
            return lastCommittedTransaction.checksum();
        }
        try {
            return this.logicalTransactionStore.getMetadataFor(txId).getChecksum();
        }
        catch (NoSuchTransactionException e) {
            TransactionId lastUpgradeTransaction = this.transactionIdStore.getUpgradeTransaction();
            if (lastUpgradeTransaction.transactionId() == txId) {
                return lastUpgradeTransaction.checksum();
            }
            throw (NoSuchTransactionException)Exceptions.withMessage((Throwable)e, (String)(e.getMessage() + " | transaction id store says last transaction is " + lastCommittedTransaction + " and last upgrade transaction is " + lastUpgradeTransaction));
        }
    }
}

