/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.master;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.ha.com.master.Slave;
import org.neo4j.kernel.ha.com.master.SlavePriority;

public abstract class SlavePriorities {
    private static final Comparator<Slave> SERVER_ID_COMPARATOR = new Comparator<Slave>(){

        @Override
        public int compare(Slave first, Slave second) {
            return first.getServerId() - second.getServerId();
        }
    };
    private static final Comparator<Slave> REVERSE_SERVER_ID_COMPARATOR = Collections.reverseOrder(SERVER_ID_COMPARATOR);

    private SlavePriorities() {
    }

    public static SlavePriority givenOrder() {
        return new SlavePriority(){

            @Override
            public Iterable<Slave> prioritize(Iterable<Slave> slaves) {
                return slaves;
            }
        };
    }

    public static SlavePriority roundRobin() {
        return new SlavePriority(){
            final AtomicInteger index = new AtomicInteger();

            @Override
            public Iterable<Slave> prioritize(Iterable<Slave> slaves) {
                final List slaveList = SlavePriorities.sortSlaves(slaves, true);
                if (slaveList.isEmpty()) {
                    return Iterables.empty();
                }
                return new Iterable<Slave>(){

                    @Override
                    public Iterator<Slave> iterator() {
                        return new PrefetchingIterator<Slave>(){
                            private int start;
                            private int count;
                            {
                                this.start = index.getAndIncrement() % slaveList.size();
                            }

                            protected Slave fetchNextOrNull() {
                                int id;
                                return (id = this.count++) <= slaveList.size() ? (Slave)slaveList.get((this.start + id) % slaveList.size()) : null;
                            }
                        };
                    }
                };
            }
        };
    }

    public static SlavePriority fixed() {
        return new SlavePriority(){

            @Override
            public Iterable<Slave> prioritize(Iterable<Slave> slaves) {
                return SlavePriorities.sortSlaves(slaves, false);
            }
        };
    }

    private static List<Slave> sortSlaves(Iterable<Slave> slaves, boolean asc) {
        ArrayList slaveList = (ArrayList)Iterables.addAll(new ArrayList(), slaves);
        Collections.sort(slaveList, asc ? SERVER_ID_COMPARATOR : REVERSE_SERVER_ID_COMPARATOR);
        return slaveList;
    }
}

