/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.id;

import java.io.File;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.com.Response;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.id.IdAllocation;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;

public class HaIdGeneratorFactory
implements IdGeneratorFactory {
    private final Map<IdType, HaIdGenerator> generators = new EnumMap<IdType, HaIdGenerator>(IdType.class);
    private final IdGeneratorFactory localFactory = new DefaultIdGeneratorFactory();
    private final DelegateInvocationHandler<Master> master;
    private final StringLogger logger;
    private final RequestContextFactory requestContextFactory;
    private IdGeneratorState globalState = IdGeneratorState.PENDING;
    private static final long VALUE_REPRESENTING_NULL = -1L;
    private static IdRangeIterator EMPTY_ID_RANGE_ITERATOR = new IdRangeIterator(new IdRange(PrimitiveLongCollections.EMPTY_LONG_ARRAY, 0L, 0)){

        @Override
        long next() {
            return -1L;
        }
    };

    public HaIdGeneratorFactory(DelegateInvocationHandler<Master> master, Logging logging, RequestContextFactory requestContextFactory) {
        this.master = master;
        this.logger = logging.getMessagesLog(this.getClass());
        this.requestContextFactory = requestContextFactory;
    }

    public IdGenerator open(FileSystemAbstraction fs, File fileName, int grabSize, IdType idType, long highId) {
        IdGenerator initialIdGenerator;
        HaIdGenerator previous = this.generators.remove(idType);
        if (previous != null) {
            previous.close();
        }
        switch (this.globalState) {
            case MASTER: {
                initialIdGenerator = this.localFactory.open(fs, fileName, grabSize, idType, highId);
                break;
            }
            case SLAVE: {
                fs.deleteFile(fileName);
                initialIdGenerator = new SlaveIdGenerator(idType, highId, this.master.cement(), this.logger, this.requestContextFactory);
                break;
            }
            default: {
                throw new IllegalStateException(this.globalState.name());
            }
        }
        HaIdGenerator haIdGenerator = new HaIdGenerator(initialIdGenerator, fs, fileName, grabSize, idType, this.globalState);
        this.generators.put(idType, haIdGenerator);
        return haIdGenerator;
    }

    public void create(FileSystemAbstraction fs, File fileName, long highId) {
        this.localFactory.create(fs, fileName, highId);
    }

    public IdGenerator get(IdType idType) {
        return this.generators.get(idType);
    }

    public void switchToMaster() {
        this.globalState = IdGeneratorState.MASTER;
        for (HaIdGenerator generator : this.generators.values()) {
            generator.switchToMaster();
        }
    }

    public void enableCompatibilityMode() {
        this.generators.get(IdType.RELATIONSHIP_GROUP).switchToMaster();
    }

    public void switchToSlave() {
        this.globalState = IdGeneratorState.SLAVE;
        for (HaIdGenerator generator : this.generators.values()) {
            generator.switchToSlave(this.master.cement());
        }
    }

    static /* synthetic */ IdRangeIterator access$500() {
        return EMPTY_ID_RANGE_ITERATOR;
    }

    private static class IdRangeIterator {
        private int position = 0;
        private final long[] defrag;
        private final long start;
        private final int length;

        IdRangeIterator(IdRange idRange) {
            this.defrag = idRange.getDefragIds();
            this.start = idRange.getRangeStart();
            this.length = idRange.getRangeLength();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long next() {
            try {
                if (this.position < this.defrag.length) {
                    long l = this.defrag[this.position];
                    return l;
                }
                int offset = this.position - this.defrag.length;
                long l = offset < this.length ? this.start + (long)offset : -1L;
                return l;
            }
            finally {
                ++this.position;
            }
        }

        public String toString() {
            return "IdRangeIterator[start:" + this.start + ", length:" + this.length + ", position:" + this.position + ", defrag:" + Arrays.toString(this.defrag) + "]";
        }
    }

    private static class SlaveIdGenerator
    implements IdGenerator {
        private volatile long highestIdInUse;
        private volatile long defragCount;
        private volatile IdRangeIterator idQueue = HaIdGeneratorFactory.access$500();
        private final Master master;
        private final IdType idType;
        private final StringLogger logger;
        private final RequestContextFactory requestContextFactory;

        SlaveIdGenerator(IdType idType, long highId, Master master, StringLogger logger, RequestContextFactory requestContextFactory) {
            this.idType = idType;
            this.highestIdInUse = highId;
            this.master = master;
            this.logger = logger;
            this.requestContextFactory = requestContextFactory;
        }

        public void close() {
        }

        public void freeId(long id) {
        }

        public long getHighId() {
            return this.highestIdInUse;
        }

        public long getHighestPossibleIdInUse() {
            return this.highestIdInUse;
        }

        public long getNumberOfIdsInUse() {
            return this.highestIdInUse - this.defragCount;
        }

        public synchronized long nextId() {
            long nextId = this.nextLocalId();
            if (nextId == -1L) {
                try (Response<IdAllocation> response = this.master.allocateIds(this.requestContextFactory.newRequestContext(), this.idType);){
                    IdAllocation allocation = (IdAllocation)response.response();
                    this.logger.info("Received id allocation " + allocation + " from master " + this.master + " for " + this.idType);
                    nextId = this.storeLocally(allocation);
                }
            }
            return nextId;
        }

        public IdRange nextIdBatch(int size) {
            throw new UnsupportedOperationException("Should never be called");
        }

        private long storeLocally(IdAllocation allocation) {
            this.setHighId(allocation.getHighestIdInUse());
            this.defragCount = allocation.getDefragCount();
            this.idQueue = new IdRangeIterator(allocation.getIdRange());
            return this.idQueue.next();
        }

        private long nextLocalId() {
            return this.idQueue.next();
        }

        public void setHighId(long id) {
            this.highestIdInUse = Math.max(this.highestIdInUse, id);
        }

        public long getDefragCount() {
            return this.defragCount;
        }

        public void delete() {
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.idQueue + "]";
        }
    }

    private class HaIdGenerator
    implements IdGenerator {
        private volatile IdGenerator delegate;
        private final FileSystemAbstraction fs;
        private final File fileName;
        private final int grabSize;
        private final IdType idType;
        private volatile IdGeneratorState state;

        HaIdGenerator(IdGenerator initialDelegate, FileSystemAbstraction fs, File fileName, int grabSize, IdType idType, IdGeneratorState initialState) {
            this.delegate = initialDelegate;
            this.fs = fs;
            this.fileName = fileName;
            this.grabSize = grabSize;
            this.idType = idType;
            this.state = initialState;
            HaIdGeneratorFactory.this.logger.debug("Instantiated HaIdGenerator for " + initialDelegate + " " + idType + ", " + (Object)((Object)initialState));
        }

        private void switchToSlave(Master master) {
            long highId = this.delegate.getHighId();
            this.delegate.delete();
            this.delegate = new SlaveIdGenerator(this.idType, highId, master, HaIdGeneratorFactory.this.logger, HaIdGeneratorFactory.this.requestContextFactory);
            HaIdGeneratorFactory.this.logger.debug("Instantiated slave delegate " + this.delegate + " of type " + this.idType + " with highid " + highId);
            this.state = IdGeneratorState.SLAVE;
        }

        private void switchToMaster() {
            if (this.state == IdGeneratorState.SLAVE) {
                long highId = this.delegate.getHighId();
                this.delegate.delete();
                HaIdGeneratorFactory.this.localFactory.create(this.fs, this.fileName, highId);
                this.delegate = HaIdGeneratorFactory.this.localFactory.open(this.fs, this.fileName, this.grabSize, this.idType, highId);
                HaIdGeneratorFactory.this.logger.debug("Instantiated master delegate " + this.delegate + " of type " + this.idType + " with highid " + highId);
            } else {
                HaIdGeneratorFactory.this.logger.debug("Keeps " + this.delegate);
            }
            this.state = IdGeneratorState.MASTER;
        }

        public String toString() {
            return this.delegate.toString();
        }

        public final boolean equals(Object other) {
            return this.delegate.equals(other);
        }

        public final int hashCode() {
            return this.delegate.hashCode();
        }

        public long nextId() {
            if (this.state == IdGeneratorState.PENDING) {
                throw new IllegalStateException(this.state.name());
            }
            long result = this.delegate.nextId();
            return result;
        }

        public IdRange nextIdBatch(int size) {
            if (this.state == IdGeneratorState.PENDING) {
                throw new IllegalStateException(this.state.name());
            }
            return this.delegate.nextIdBatch(size);
        }

        public void setHighId(long id) {
            this.delegate.setHighId(id);
        }

        public long getHighId() {
            return this.delegate.getHighId();
        }

        public long getHighestPossibleIdInUse() {
            return this.delegate.getHighestPossibleIdInUse();
        }

        public void freeId(long id) {
            this.delegate.freeId(id);
        }

        public void close() {
            this.delegate.close();
        }

        public long getNumberOfIdsInUse() {
            return this.delegate.getNumberOfIdsInUse();
        }

        public long getDefragCount() {
            return this.delegate.getDefragCount();
        }

        public void delete() {
            this.delegate.delete();
        }
    }

    private static enum IdGeneratorState {
        PENDING,
        SLAVE,
        MASTER;

    }
}

