/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock.forseti;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.collection.pool.LinkedQueuePool;
import org.neo4j.collection.pool.Pool;
import org.neo4j.kernel.ha.lock.forseti.ForsetiClient;
import org.neo4j.kernel.impl.locking.AcquireLockTimeoutException;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.util.collection.SimpleBitSet;
import org.neo4j.kernel.impl.util.concurrent.WaitStrategy;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class ForsetiLockManager
extends LifecycleAdapter
implements Locks {
    private final ConcurrentMap<Long, Lock>[] lockMaps;
    private final Locks.ResourceType[] resourceTypes;
    private final Pool<ForsetiClient> clientPool;

    public ForsetiLockManager(Locks.ResourceType ... resourceTypes) {
        this.lockMaps = new ConcurrentMap[this.findMaxResourceId(resourceTypes)];
        this.resourceTypes = new Locks.ResourceType[this.findMaxResourceId(resourceTypes)];
        WaitStrategy[] waitStrategies = new WaitStrategy[this.findMaxResourceId(resourceTypes)];
        for (Locks.ResourceType type : resourceTypes) {
            this.lockMaps[type.typeId()] = new ConcurrentHashMap<Long, Lock>(16, 0.6f, 512);
            waitStrategies[type.typeId()] = type.waitStrategy();
            this.resourceTypes[type.typeId()] = type;
        }
        this.clientPool = new ForsetiClientFlyweightPool(this.lockMaps, waitStrategies);
    }

    public Locks.Client newClient() {
        return (Locks.Client)this.clientPool.acquire();
    }

    public void accept(Locks.Visitor out) {
        for (int i = 0; i < this.lockMaps.length; ++i) {
            if (this.lockMaps[i] == null) continue;
            Locks.ResourceType type = this.resourceTypes[i];
            for (Map.Entry entry : this.lockMaps[i].entrySet()) {
                Lock lock = (Lock)entry.getValue();
                out.visit(type, ((Long)entry.getKey()).longValue(), lock.describeWaitList(), 0L);
            }
        }
    }

    private int findMaxResourceId(Locks.ResourceType[] resourceTypes) {
        int max = 0;
        for (Locks.ResourceType resourceType : resourceTypes) {
            max = Math.max(resourceType.typeId(), max);
        }
        return max + 1;
    }

    private static class ForsetiClientFlyweightPool
    extends LinkedQueuePool<ForsetiClient> {
        private final AtomicInteger clientIds = new AtomicInteger(0);
        private final Queue<Integer> unusedIds = new ConcurrentLinkedQueue<Integer>();
        private final ConcurrentMap<Long, Lock>[] lockMaps;
        private final WaitStrategy<AcquireLockTimeoutException>[] waitStrategies;

        public ForsetiClientFlyweightPool(ConcurrentMap<Long, Lock>[] lockMaps, WaitStrategy<AcquireLockTimeoutException>[] waitStrategies) {
            super(128, null);
            this.lockMaps = lockMaps;
            this.waitStrategies = waitStrategies;
        }

        protected ForsetiClient create() {
            Integer id = this.unusedIds.poll();
            if (id == null) {
                id = this.clientIds.getAndIncrement();
            }
            return new ForsetiClient(id, this.lockMaps, this.waitStrategies, this);
        }

        protected void dispose(ForsetiClient resource) {
            super.dispose((Object)resource);
            if (resource.id() < 1024) {
                this.unusedIds.offer(resource.id());
            }
        }
    }

    static interface Lock {
        public void copyHolderWaitListsInto(SimpleBitSet var1);

        public int holderWaitListSize();

        public boolean anyHolderIsWaitingFor(int var1);

        public String describeWaitList();
    }
}

