/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.store;

import java.util.Map;
import org.neo4j.kernel.ha.store.HighAvailabilityStoreFailureException;
import org.neo4j.kernel.impl.store.StoreId;

public class InconsistentlyUpgradedClusterException
extends HighAvailabilityStoreFailureException {
    private static final String MESSAGE_FORMAT = "Detected separately upgraded members of the cluster. This machine has %s, other members: %s";

    public InconsistentlyUpgradedClusterException(StoreId myStoreId, Map<Integer, StoreId> mismatched) {
        super(String.format(MESSAGE_FORMAT, myStoreId, InconsistentlyUpgradedClusterException.formMismatchedString(mismatched)));
    }

    private static String formMismatchedString(Map<Integer, StoreId> mismatched) {
        StringBuilder sb = new StringBuilder("[");
        for (Map.Entry<Integer, StoreId> entry : mismatched.entrySet()) {
            sb.append("Instance ").append(entry.getKey()).append(" has ").append(entry.getValue()).append(",");
        }
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }
}

