/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.com.ComException;
import org.neo4j.function.Function;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.Predicates;
import org.neo4j.helpers.TransactionTemplate;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.api.integrationtest.UniquenessConstraintValidationConcurrencyIT;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.test.OtherThreadRule;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

public class UniquenessConstraintValidationHAIT {
    @Rule
    public final LifeRule life = new LifeRule();
    @Rule
    public final TargetDirectory.TestDirectory targetDir = TargetDirectory.testDirForTest(UniquenessConstraintValidationHAIT.class);
    @Rule
    public final OtherThreadRule<Void> otherThread = new OtherThreadRule();

    @Before
    public void startLife() {
        this.life.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAllowCreationOfNonConflictingDataOnSeparateHosts() throws Exception {
        Future created;
        ClusterManager.ManagedCluster cluster = this.startClusterSeededWith(this.databaseWithUniquenessConstraint("Label1", "key1"));
        HighlyAvailableGraphDatabase slave1 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave2 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[]{slave1});
        Transaction tx = slave1.beginTx();
        try {
            slave1.createNode(new Label[]{DynamicLabel.label((String)"Label1")}).setProperty("key1", (Object)"value1");
            created = this.otherThread.execute(UniquenessConstraintValidationConcurrencyIT.createNode((GraphDatabaseService)slave2, (String)"Label1", (String)"key1", (Object)"value2"));
            tx.success();
        }
        finally {
            tx.finish();
        }
        Assert.assertTrue((String)"creating non-conflicting data should pass", (boolean)((Boolean)created.get()));
    }

    @Test
    public void shouldPreventConcurrentCreationOfConflictingDataOnSeparateHosts() throws Exception {
        ClusterManager.ManagedCluster cluster = this.startClusterSeededWith(this.databaseWithUniquenessConstraint("Label1", "key1"));
        final HighlyAvailableGraphDatabase slave1 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        final HighlyAvailableGraphDatabase slave2 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[]{slave1});
        TransactionTemplate template = new TransactionTemplate().retries(3).backoff(10L, TimeUnit.SECONDS).retryOn(Predicates.instanceOf(ComException.class)).with((GraphDatabaseService)slave1);
        Future created = (Future)template.execute((Function)new Function<Transaction, Future<Boolean>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Future<Boolean> apply(Transaction transaction) throws RuntimeException {
                slave1.createNode(new Label[]{DynamicLabel.label((String)"Label1")}).setProperty("key1", (Object)"value1");
                try {
                    Future future = UniquenessConstraintValidationHAIT.this.otherThread.execute(UniquenessConstraintValidationConcurrencyIT.createNode((GraphDatabaseService)slave2, (String)"Label1", (String)"key1", (Object)"value1"));
                    return future;
                }
                finally {
                    Assert.assertThat(UniquenessConstraintValidationHAIT.this.otherThread, (Matcher)OtherThreadRule.isWaiting());
                }
            }
        });
        Assert.assertFalse((String)"creating violating data should fail", (boolean)((Boolean)created.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldPreventConcurrentCreationOfConflictingNonStringPropertyOnMasterAndSlave() throws Exception {
        Future created;
        ClusterManager.ManagedCluster cluster = this.startClusterSeededWith(this.databaseWithUniquenessConstraint("Label1", "key1"));
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        Transaction tx = master.beginTx();
        try {
            master.createNode(new Label[]{DynamicLabel.label((String)"Label1")}).setProperty("key1", (Object)39372);
            created = this.otherThread.execute(UniquenessConstraintValidationConcurrencyIT.createNode((GraphDatabaseService)slave, (String)"Label1", (String)"key1", (Object)39372));
            Assert.assertThat(this.otherThread, (Matcher)OtherThreadRule.isWaiting());
            tx.success();
        }
        finally {
            tx.finish();
        }
        Assert.assertFalse((String)"creating violating data should fail", (boolean)((Boolean)created.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAllowOtherHostToCompleteIfFirstHostRollsBackTransaction() throws Exception {
        Future created;
        ClusterManager.ManagedCluster cluster = this.startClusterSeededWith(this.databaseWithUniquenessConstraint("Label1", "key1"));
        HighlyAvailableGraphDatabase slave1 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave2 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[]{slave1});
        Transaction tx = slave1.beginTx();
        try {
            slave1.createNode(new Label[]{DynamicLabel.label((String)"Label1")}).setProperty("key1", (Object)"value1");
            created = this.otherThread.execute(UniquenessConstraintValidationConcurrencyIT.createNode((GraphDatabaseService)slave2, (String)"Label1", (String)"key1", (Object)"value1"));
            Assert.assertThat(this.otherThread, (Matcher)OtherThreadRule.isWaiting());
            tx.failure();
        }
        finally {
            tx.finish();
        }
        Assert.assertTrue((String)"creating data that conflicts only with rolled back data should pass", (boolean)((Boolean)created.get()));
    }

    private ClusterManager.ManagedCluster startClusterSeededWith(File seedDir) {
        ClusterManager.ManagedCluster cluster = ((ClusterManager)this.life.add((Lifecycle)new ClusterManager.Builder(this.targetDir.directory()).withSeedDir(seedDir).build())).getDefaultCluster();
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        return cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File databaseWithUniquenessConstraint(String label, String propertyKey) {
        File storeDir = new File(this.targetDir.directory(), "seed");
        GraphDatabaseService graphDb = new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir.getAbsolutePath());
        try {
            Transaction tx = graphDb.beginTx();
            try {
                graphDb.schema().constraintFor(DynamicLabel.label((String)label)).assertPropertyIsUnique(propertyKey).create();
                tx.success();
            }
            finally {
                tx.finish();
            }
        }
        finally {
            graphDb.shutdown();
        }
        return storeDir;
    }
}

