/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha.correctness;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterMessage;
import org.neo4j.ha.correctness.ClusterAction;
import org.neo4j.ha.correctness.ClusterInstance;
import org.neo4j.ha.correctness.ClusterState;
import org.neo4j.ha.correctness.GraphVizExporter;
import org.neo4j.ha.correctness.InstanceCrashedAction;
import org.neo4j.ha.correctness.MessageDeliveryAction;
import org.neo4j.ha.correctness.ProofDatabase;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.util.TestLogging;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

public class Prover {
    private final Queue<ClusterState> unexploredKnownStates = new LinkedList<ClusterState>();
    private final ProofDatabase db = new ProofDatabase("./clusterproof");

    public static void main(String ... args) throws Exception {
        new Prover().prove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prove() throws Exception {
        try {
            System.out.println("Bootstrap genesis state..");
            this.bootstrapCluster();
            System.out.println("Begin exploring delivery orders.");
            this.exploreUnexploredStates();
            System.out.println("Exporting graphviz..");
            this.db.export(new GraphVizExporter(new File("./proof.gs")));
        }
        finally {
            this.db.shutdown();
        }
    }

    private void bootstrapCluster() throws Exception {
        TestLogging logging = new TestLogging();
        String instance1 = "cluster://localhost:5001";
        String instance2 = "cluster://localhost:5002";
        String instance3 = "cluster://localhost:5003";
        ClusterConfiguration config = new ClusterConfiguration("default", logging.getMessagesLog(ClusterConfiguration.class), new String[]{instance1, instance2, instance3});
        ClusterState state = new ClusterState(Arrays.asList(ClusterInstance.newClusterInstance(new InstanceId(1), new URI(instance1), new Monitors(), config, (Logging)logging), ClusterInstance.newClusterInstance(new InstanceId(2), new URI(instance2), new Monitors(), config, (Logging)logging), ClusterInstance.newClusterInstance(new InstanceId(3), new URI(instance3), new Monitors(), config, (Logging)logging)), IteratorUtil.emptySetOf(ClusterAction.class));
        state = state.performAction(new MessageDeliveryAction(Message.to((MessageType)ClusterMessage.create, (URI)new URI(instance3), (Object)"defaultcluster").setHeader("conversation-id", "-1").setHeader("from", instance3)));
        state = state.performAction(new MessageDeliveryAction(Message.to((MessageType)ClusterMessage.join, (URI)new URI(instance2), (Object)new Object[]{"defaultcluster", new URI[]{new URI(instance3)}}).setHeader("conversation-id", "-1").setHeader("from", instance2)));
        state = state.performAction(new MessageDeliveryAction(Message.to((MessageType)ClusterMessage.join, (URI)new URI(instance1), (Object)new Object[]{"defaultcluster", new URI[]{new URI(instance3)}}).setHeader("conversation-id", "-1").setHeader("from", instance1)));
        state.addPendingActions(new InstanceCrashedAction(instance3));
        this.unexploredKnownStates.add(state);
        this.db.newState(state);
    }

    private void exploreUnexploredStates() {
        while (!this.unexploredKnownStates.isEmpty()) {
            ClusterState state = this.unexploredKnownStates.poll();
            Iterator<Pair<ClusterAction, ClusterState>> newStates = state.transitions();
            while (newStates.hasNext()) {
                Pair<ClusterAction, ClusterState> next = newStates.next();
                System.out.println(this.db.numberOfKnownStates() + " (" + this.unexploredKnownStates.size() + ")");
                ClusterState nextState = (ClusterState)next.other();
                if (this.db.isKnownState(nextState)) continue;
                this.db.newStateTransition(state, next);
                this.unexploredKnownStates.offer(nextState);
                if (!nextState.isDeadEnd()) continue;
                System.out.println("DEAD END: " + nextState.toString() + " (" + this.db.id(nextState) + ")");
            }
        }
    }
}

