/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.LoggerRule;
import org.neo4j.test.TargetDirectory;

public class TestBasicHaOperations {
    @Rule
    public LoggerRule logger = new LoggerRule();
    public TargetDirectory dir = TargetDirectory.forTest(this.getClass());
    private ClusterManager clusterManager;

    @After
    public void after() throws Throwable {
        if (this.clusterManager != null) {
            this.clusterManager.stop();
            this.clusterManager = null;
        }
    }

    @Test
    public void testBasicFailover() throws Throwable {
        this.clusterManager = new ClusterManager(ClusterManager.clusterOfSize((int)3), this.dir.cleanDirectory("failover"), MapUtil.stringMap((String[])new String[0]));
        this.clusterManager.start();
        ClusterManager.ManagedCluster cluster = this.clusterManager.getDefaultCluster();
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        HighlyAvailableGraphDatabase slave1 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave2 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[]{slave1});
        long start = System.nanoTime();
        cluster.shutdown(master);
        this.logger.getLogger().warn("Shut down master");
        cluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[0]));
        long end = System.nanoTime();
        this.logger.getLogger().warn("Failover took:" + (end - start) / 1000000L + "ms");
        boolean slave1Master = slave1.isMaster();
        boolean slave2Master = slave2.isMaster();
        if (slave1Master) {
            Assert.assertFalse((boolean)slave2Master);
        } else {
            Assert.assertTrue((boolean)slave2Master);
        }
    }

    @Test
    public void testBasicPropagationFromSlaveToMaster() throws Throwable {
        long nodeId;
        this.clusterManager = new ClusterManager(ClusterManager.clusterOfSize((int)2), this.dir.cleanDirectory("propagation"), MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_factor.name(), "1"}));
        this.clusterManager.start();
        ClusterManager.ManagedCluster cluster = this.clusterManager.getDefaultCluster();
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try (Transaction tx = master.beginTx();){
            Node node = master.createNode();
            nodeId = node.getId();
            node.setProperty("foo", (Object)"bar");
            tx.success();
        }
        tx = master.beginTx();
        var7_5 = null;
        try {
            master.getNodeById(nodeId).getProperty("foo");
            tx.success();
        }
        catch (Throwable x2) {
            var7_5 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var7_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var7_5.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        ((UpdatePuller)slave.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
        tx = slave.beginTx();
        var7_5 = null;
        try {
            slave.getNodeById(nodeId).setProperty("foo", (Object)"bar2");
            tx.success();
        }
        catch (Throwable x2) {
            var7_5 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var7_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var7_5.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = master.beginTx();
        var7_5 = null;
        try {
            Assert.assertEquals((Object)"bar2", (Object)master.getNodeById(nodeId).getProperty("foo"));
            tx.success();
        }
        catch (Throwable throwable) {
            var7_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var7_5.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void testBasicPropagationFromMasterToSlave() throws Throwable {
        String value;
        this.clusterManager = new ClusterManager(ClusterManager.clusterOfSize((int)3), this.dir.cleanDirectory("propagation"), MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_factor.name(), "2"}));
        this.clusterManager.start();
        ClusterManager.ManagedCluster cluster = this.clusterManager.getDefaultCluster();
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        long nodeId = 4L;
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        try (Transaction tx = master.beginTx();){
            Node node = master.createNode();
            node.setProperty("Hello", (Object)"World");
            nodeId = node.getId();
            tx.success();
        }
        HighlyAvailableGraphDatabase slave1 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try (Transaction tx = slave1.beginTx();){
            value = slave1.getNodeById(nodeId).getProperty("Hello").toString();
            this.logger.getLogger().info("Hello=" + value);
            Assert.assertEquals((Object)"World", (Object)value);
            tx.success();
        }
        HighlyAvailableGraphDatabase slave2 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[]{slave1});
        try (Transaction tx = slave2.beginTx();){
            value = slave2.getNodeById(nodeId).getProperty("Hello").toString();
            this.logger.getLogger().info("Hello=" + value);
            Assert.assertEquals((Object)"World", (Object)value);
            tx.success();
        }
    }
}

