/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.UpdatePullerScheduler;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.test.OnDemandJobScheduler;

public class UpdatePullerSchedulerTest {
    private UpdatePuller updatePuller;
    private Logging logging;

    @Before
    public void setUp() {
        this.updatePuller = (UpdatePuller)Mockito.mock(UpdatePuller.class);
        this.logging = (Logging)Mockito.mock(Logging.class);
    }

    @Test
    public void skipUpdatePullingSchedulingWithZeroInterval() throws Throwable {
        JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
        UpdatePullerScheduler pullerScheduler = new UpdatePullerScheduler(this.updatePuller, jobScheduler, this.logging, 0L);
        pullerScheduler.init();
        Mockito.verifyZeroInteractions((Object[])new Object[]{jobScheduler, this.updatePuller});
        pullerScheduler.shutdown();
    }

    @Test
    public void scheduleUpdatePulling() throws Throwable {
        OnDemandJobScheduler demandJobScheduler = new OnDemandJobScheduler();
        UpdatePullerScheduler pullerScheduler = new UpdatePullerScheduler(this.updatePuller, (JobScheduler)demandJobScheduler, this.logging, 10L);
        pullerScheduler.init();
        demandJobScheduler.runJob();
        ((UpdatePuller)Mockito.verify((Object)this.updatePuller)).pullUpdates();
        Assert.assertNotNull((String)"Job should be scheduled", (Object)demandJobScheduler.getJob());
        pullerScheduler.shutdown();
        Assert.assertNull((String)"Job should be canceled", (Object)demandJobScheduler.getJob());
    }
}

