/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.Clock;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.SlaveLockManager;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.community.CommunityLockManger;

public class SlaveLockManagerTest {
    @Test
    public void shutsDownLocalLocks() throws Throwable {
        Locks localLocks = (Locks)Mockito.mock(Locks.class);
        SlaveLockManager slaveLockManager = SlaveLockManagerTest.newSlaveLockManager(localLocks);
        slaveLockManager.shutdown();
        ((Locks)Mockito.verify((Object)localLocks)).shutdown();
    }

    @Test
    public void doesNotCreateClientsAfterShutdown() throws Throwable {
        SlaveLockManager slaveLockManager = SlaveLockManagerTest.newSlaveLockManager((Locks)new CommunityLockManger());
        Assert.assertNotNull((Object)slaveLockManager.newClient());
        slaveLockManager.shutdown();
        try {
            slaveLockManager.newClient();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    private static SlaveLockManager newSlaveLockManager(Locks localLocks) {
        return new SlaveLockManager(localLocks, new RequestContextFactory(1, (DependencyResolver)Mockito.mock(DependencyResolver.class)), (Master)Mockito.mock(Master.class), new AvailabilityGuard(Clock.SYSTEM_CLOCK), (SlaveLockManager.Configuration)Mockito.mock(SlaveLockManager.Configuration.class));
    }
}

