/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.logging.Logging;

public class UpdatePullerScheduler
extends LifecycleAdapter {
    private final UpdatePuller updatePuller;
    private final JobScheduler scheduler;
    private final StringLogger logger;
    private final long pullIntervalMillis;
    private JobScheduler.JobHandle intervalJobHandle;

    public UpdatePullerScheduler(UpdatePuller updatePuller, JobScheduler scheduler, Logging logging, long pullIntervalMillis) {
        this.updatePuller = updatePuller;
        this.scheduler = scheduler;
        this.logger = logging.getMessagesLog(((Object)((Object)this)).getClass());
        this.pullIntervalMillis = pullIntervalMillis;
    }

    public void init() throws Throwable {
        if (this.pullIntervalMillis > 0L) {
            this.intervalJobHandle = this.scheduler.scheduleRecurring(JobScheduler.Group.pullUpdates, new Runnable(){

                @Override
                public void run() {
                    try {
                        UpdatePullerScheduler.this.updatePuller.pullUpdates();
                    }
                    catch (InterruptedException e) {
                        UpdatePullerScheduler.this.logger.error("Pull updates failed", (Throwable)e);
                    }
                }
            }, this.pullIntervalMillis, this.pullIntervalMillis, TimeUnit.MILLISECONDS);
        }
    }

    public void shutdown() throws Throwable {
        if (this.intervalJobHandle != null) {
            this.intervalJobHandle.cancel(false);
        }
    }
}

