/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.transaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.locking.AcquireLockTimeoutException;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.state.PropertyDeleter;
import org.neo4j.kernel.impl.transaction.state.PropertyTraverser;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RecordAccessSet;
import org.neo4j.kernel.impl.transaction.state.RecordChangeSet;
import org.neo4j.kernel.impl.transaction.state.RelationshipCreator;
import org.neo4j.kernel.impl.transaction.state.RelationshipDeleter;
import org.neo4j.kernel.impl.transaction.state.RelationshipGroupGetter;
import org.neo4j.kernel.impl.transaction.state.RelationshipLocker;

public class DenseNodeTransactionTranslator
implements Function<List<LogEntry>, List<LogEntry>> {
    private final NeoStore neoStore;
    private final List<LogEntryCommand> commands = new LinkedList<LogEntryCommand>();
    private final RelationshipGroupGetter groupGetter;
    private final RelationshipCreator relationshipCreator;
    private final RelationshipDeleter deleter;
    private final TranslatingNeoCommandVisitor commandVisitor = new TranslatingNeoCommandVisitor();
    private RecordChangeSet recordChangeSet;

    public DenseNodeTransactionTranslator(NeoStore neoStore) {
        this.neoStore = neoStore;
        this.groupGetter = new RelationshipGroupGetter(neoStore.getRelationshipGroupStore());
        this.relationshipCreator = new RelationshipCreator(new RelationshipLocker(){

            public void getWriteLock(long relId) throws AcquireLockTimeoutException {
            }
        }, this.groupGetter, 1);
        this.deleter = new RelationshipDeleter(new RelationshipLocker(){

            public void getWriteLock(long relId) throws AcquireLockTimeoutException {
            }
        }, this.groupGetter, new PropertyDeleter(neoStore.getPropertyStore(), new PropertyTraverser()));
    }

    public synchronized List<LogEntry> apply(List<LogEntry> from) {
        this.recordChangeSet = new RecordChangeSet(this.neoStore);
        this.commands.clear();
        ArrayList<LogEntry> result = new ArrayList<LogEntry>(from.size());
        LogEntry commit = null;
        Object prepare = null;
        Object done = null;
        block7: for (LogEntry logEntry : from) {
            if (logEntry.getVersion() == LogEntryVersion.CURRENT) {
                throw new RuntimeException("crap");
            }
            switch (logEntry.getType()) {
                case 1: {
                    result.add(logEntry);
                    break;
                }
                case 5: {
                    commit = logEntry;
                    break;
                }
                case 3: {
                    try {
                        if (this.handleCommand((LogEntryCommand)logEntry)) continue block7;
                        this.commands.add((LogEntryCommand)logEntry);
                        break;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                default: {
                    throw new IllegalStateException("Log Entry type " + logEntry.getType() + " is not recognizable");
                }
            }
        }
        this.translateRecordChangeSetToEntries(result, this.commands);
        if (commit != null) {
            result.add(commit);
        }
        if (prepare != null) {
            result.add((LogEntry)prepare);
        }
        if (done != null) {
            result.add((LogEntry)done);
        }
        return result;
    }

    private void translateRecordChangeSetToEntries(List<LogEntry> result, List<LogEntryCommand> commands) {
        Command.NodeCommand newCommand;
        for (RecordAccess.RecordProxy nodeChange : this.recordChangeSet.getNodeRecords().changes()) {
            newCommand = new Command.NodeCommand();
            newCommand.init((NodeRecord)nodeChange.getBefore(), (NodeRecord)nodeChange.forChangingData());
            result.add((LogEntry)new LogEntryCommand((Command)newCommand));
        }
        for (RecordAccess.RecordProxy relChange : this.recordChangeSet.getRelRecords().changes()) {
            newCommand = new Command.RelationshipCommand();
            newCommand.init((RelationshipRecord)relChange.forChangingData());
            result.add((LogEntry)new LogEntryCommand((Command)newCommand));
        }
        for (RecordAccess.RecordProxy relGroupChange : this.recordChangeSet.getRelGroupRecords().changes()) {
            newCommand = new Command.RelationshipGroupCommand();
            newCommand.init((RelationshipGroupRecord)relGroupChange.forChangingData());
            result.add((LogEntry)new LogEntryCommand((Command)newCommand));
        }
        for (RecordAccess.RecordProxy propChange : this.recordChangeSet.getPropertyRecords().changes()) {
            newCommand = new Command.PropertyCommand();
            newCommand.init((PropertyRecord)propChange.getBefore(), (PropertyRecord)propChange.forChangingData());
            result.add((LogEntry)new LogEntryCommand((Command)newCommand));
        }
        for (LogEntryCommand commandEntry : commands) {
            long id;
            Command command = commandEntry.getXaCommand();
            if (command instanceof Command.RelationshipCommand) {
                id = ((Command.RelationshipCommand)command).getRecord().getId();
                if (this.recordChangeSet.getRelRecords().getIfLoaded((Object)id) != null) continue;
                result.add((LogEntry)commandEntry);
                continue;
            }
            if (command instanceof Command.NodeCommand) {
                id = ((Command.NodeCommand)command).getAfter().getId();
                if (this.recordChangeSet.getNodeRecords().getIfLoaded((Object)id) != null) continue;
                result.add((LogEntry)commandEntry);
                continue;
            }
            result.add((LogEntry)commandEntry);
        }
    }

    private boolean handleCommand(LogEntryCommand commandEntry) throws IOException {
        Command command = commandEntry.getXaCommand();
        return command.handle((NeoCommandHandler)this.commandVisitor);
    }

    private class TranslatingNeoCommandVisitor
    implements NeoCommandHandler {
        private TranslatingNeoCommandVisitor() {
        }

        public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
            NodeRecord after = command.getAfter();
            NodeRecord before = DenseNodeTransactionTranslator.this.neoStore.getNodeStore().loadLightNode(after.getId());
            if (after.inUse() && (before == null || !before.inUse())) {
                this.translateNodeCreation(command);
            } else if (!after.inUse() && before.inUse()) {
                this.translateNodeDeletion(command);
            } else {
                if (after.getNextProp() != before.getNextProp()) {
                    this.translateNodePropertyChange(command);
                }
                if (after.getLabelField() != before.getLabelField()) {
                    this.translateNodeLabelChange(command);
                }
            }
            return true;
        }

        private void translateNodeDeletion(Command.NodeCommand command) {
            ((NodeRecord)DenseNodeTransactionTranslator.this.recordChangeSet.getNodeRecords().getOrLoad((Object)command.getKey(), null).forChangingData()).setInUse(false);
        }

        private void translateNodeLabelChange(Command.NodeCommand command) {
            ((NodeRecord)DenseNodeTransactionTranslator.this.recordChangeSet.getNodeRecords().getOrLoad((Object)command.getKey(), null).forChangingData()).setLabelField(command.getAfter().getLabelField(), command.getAfter().getDynamicLabelRecords());
        }

        private void translateNodePropertyChange(Command.NodeCommand command) {
            ((NodeRecord)DenseNodeTransactionTranslator.this.recordChangeSet.getNodeRecords().getOrLoad((Object)command.getKey(), null).forChangingData()).setNextProp(command.getAfter().getNextProp());
        }

        private void translateNodeCreation(Command.NodeCommand command) {
            NodeRecord created = (NodeRecord)DenseNodeTransactionTranslator.this.recordChangeSet.getNodeRecords().create((Object)command.getKey(), null).forChangingData();
            created.copyFrom(command.getAfter());
            created.setNextRel((long)Record.NO_NEXT_RELATIONSHIP.intValue());
            created.setInUse(true);
            ((NodeRecord)DenseNodeTransactionTranslator.this.recordChangeSet.getNodeRecords().getOrLoad((Object)command.getKey(), null).forChangingData()).setNextProp(command.getAfter().getNextProp());
        }

        public boolean visitRelationshipCommand(Command.RelationshipCommand command) throws IOException {
            RelationshipRecord after = command.getRecord();
            RelationshipRecord before = DenseNodeTransactionTranslator.this.neoStore.getRelationshipStore().getLightRel(after.getId());
            if (after.inUse() && (before == null || !before.inUse())) {
                this.translateRelationshipCreation(command);
            } else if (!after.inUse() && before.inUse()) {
                this.translateRelationshipDeletion(command);
            } else if (after.getNextProp() != before.getNextProp()) {
                this.translateRelationshipPropertyChange(command);
            }
            return true;
        }

        private void translateRelationshipPropertyChange(Command.RelationshipCommand command) {
            ((RelationshipRecord)DenseNodeTransactionTranslator.this.recordChangeSet.getRelRecords().getOrLoad((Object)command.getKey(), null).forChangingData()).setNextProp(command.getRecord().getNextProp());
        }

        public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
            PrimitiveRecord additionalData = command.getAfter().isNodeSet() ? (PrimitiveRecord)DenseNodeTransactionTranslator.this.recordChangeSet.getNodeRecords().getOrLoad((Object)command.getAfter().getNodeId(), null).forReadingLinkage() : (PrimitiveRecord)DenseNodeTransactionTranslator.this.recordChangeSet.getRelRecords().getOrLoad((Object)command.getAfter().getRelId(), null).forReadingLinkage();
            DenseNodeTransactionTranslator.this.recordChangeSet.getPropertyRecords().setTo((Object)command.getKey(), (Object)command.getAfter(), (Object)additionalData);
            return true;
        }

        public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) {
            return false;
        }

        public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) {
            return false;
        }

        public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) throws IOException {
            return false;
        }

        public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) {
            return false;
        }

        public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
            return false;
        }

        public boolean visitNeoStoreCommand(Command.NeoStoreCommand command) {
            return false;
        }

        public boolean visitIndexAddNodeCommand(IndexCommand.AddNodeCommand command) throws IOException {
            return false;
        }

        public boolean visitIndexAddRelationshipCommand(IndexCommand.AddRelationshipCommand command) throws IOException {
            return false;
        }

        public boolean visitIndexRemoveCommand(IndexCommand.RemoveCommand command) throws IOException {
            return false;
        }

        public boolean visitIndexDeleteCommand(IndexCommand.DeleteCommand command) throws IOException {
            return false;
        }

        public boolean visitIndexCreateCommand(IndexCommand.CreateCommand command) throws IOException {
            return false;
        }

        public boolean visitIndexDefineCommand(IndexDefineCommand command) throws IOException {
            return false;
        }

        public boolean visitNodeCountsCommand(Command.NodeCountsCommand command) {
            return false;
        }

        public boolean visitRelationshipCountsCommand(Command.RelationshipCountsCommand command) throws IOException {
            return false;
        }

        public void apply() {
        }

        public void close() {
        }

        private void translateRelationshipCreation(Command.RelationshipCommand command) {
            RelationshipRecord record = command.getRecord();
            DenseNodeTransactionTranslator.this.relationshipCreator.relationshipCreate(record.getId(), record.getType(), record.getFirstNode(), record.getSecondNode(), (RecordAccessSet)DenseNodeTransactionTranslator.this.recordChangeSet);
            ((RelationshipRecord)DenseNodeTransactionTranslator.this.recordChangeSet.getRelRecords().getOrLoad((Object)command.getKey(), null).forChangingData()).setNextProp(command.getRecord().getNextProp());
        }

        private void translateRelationshipDeletion(Command.RelationshipCommand command) {
            RelationshipRecord record = command.getRecord();
            DenseNodeTransactionTranslator.this.deleter.relDelete(record.getId(), (RecordAccessSet)DenseNodeTransactionTranslator.this.recordChangeSet);
        }
    }
}

